/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.exception;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.core.Resource;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.GrammarToken;

public class ErrorInfo {
    String type = "";
    String errorTokenText = "";
    int errorTokenLine = 0;
    String msg;
    Throwable cause;
    String errorCode = null;
    List<Resource> resourceCallStack = null;
    List<GrammarToken> tokenCallStack = null;
    public static Map<String, String> errorLocalMap = new HashMap<String, String>();

    static String concat(String info, String code) {
        return info.concat("(").concat(code).concat(")");
    }

    public ErrorInfo(BeetlException ex) {
        this.cause = ex.getCause();
        this.errorCode = ex.detailCode;
        if (this.errorCode.startsWith("TEMPLATE")) {
            this.msg = ex.getMessage();
            this.type = errorLocalMap.get(this.errorCode);
            return;
        }
        if (this.errorCode.startsWith("PARSER")) {
            this.errorTokenText = ex.token != null ? ex.token.text : ex.getMessage();
        } else if (ex.token != null) {
            this.errorTokenText = ex.token.text;
        } else {
            ex.printStackTrace();
        }
        this.msg = ex.getMessage();
        this.errorTokenLine = ex.token.line;
        this.type = errorLocalMap.get(this.errorCode);
        if (this.type == null) {
            this.type = this.errorCode;
        }
        this.resourceCallStack = ex.errorResourceStack;
        this.tokenCallStack = ex.errorTokenStack;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getErrorTokenText() {
        return this.errorTokenText;
    }

    public void setErrorTokenText(String errorTokenText) {
        this.errorTokenText = errorTokenText;
    }

    public int getErrorTokenLine() {
        return this.errorTokenLine;
    }

    public void setErrorTokenLine(int errorTokenLine) {
        this.errorTokenLine = errorTokenLine;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public boolean hasCallStack() {
        return this.resourceCallStack.size() > 1;
    }

    public List<Resource> getResourceCallStack() {
        return this.resourceCallStack;
    }

    public void setResourceCallStack(List<Resource> resourceCallStack) {
        this.resourceCallStack = resourceCallStack;
    }

    public List<GrammarToken> getTokenCallStack() {
        return this.tokenCallStack;
    }

    public void setTokenCallStack(List<GrammarToken> tokenCallStack) {
        this.tokenCallStack = tokenCallStack;
    }

    public static Map<String, String> getErrorLocalMap() {
        return errorLocalMap;
    }

    public static void setErrorLocalMap(Map<String, String> errorLocalMap) {
        ErrorInfo.errorLocalMap = errorLocalMap;
    }

    static {
        errorLocalMap.put("ERROR", "\u9519\u8bef");
        errorLocalMap.put("DO_NOT_SUPPORT", "\u4e0d\u652f\u6301\u7684\u8bed\u6cd5");
        errorLocalMap.put("VAR_ALREADY_DEFINED", ErrorInfo.concat("\u53d8\u91cf\u5df2\u7ecf\u5b9a\u4e49", "VAR_ALREADY_DEFINED"));
        errorLocalMap.put("VAR_READONLY", ErrorInfo.concat("\u5168\u5c40\u53d8\u91cf\u4e3a\u53ea\u8bfb\u53d8\u91cf", "VAR_READONLY"));
        errorLocalMap.put("VAR_NOT_DEFINED", ErrorInfo.concat("\u53d8\u91cf\u672a\u5b9a\u4e49", "VAR_NOT_DEFINED"));
        errorLocalMap.put("FUNCTION_NOT_FOUND", ErrorInfo.concat("\u8be5\u65b9\u6cd5\u672a\u6ce8\u518c", "FUNCTION_NOT_FOUND"));
        errorLocalMap.put("FUNCTION_INVALID", ErrorInfo.concat("\u65b9\u6cd5\u672a\u5b9e\u73b0Function\u63a5\u53e3", "FUNCTION_INVALID"));
        errorLocalMap.put("TAG_NOT_FOUND", ErrorInfo.concat("\u8be5\u6807\u7b7e\u672a\u6ce8\u518c", "TAG_NOT_FOUND"));
        errorLocalMap.put("VIRTUAL_NOT_FOUND", ErrorInfo.concat("\u672a\u627e\u5230\u865a\u62df\u5c5e\u6027", "VIRTUAL_NOT_FOUND"));
        errorLocalMap.put("TAG_INSTANCE_ERROR", ErrorInfo.concat("\u521b\u5efaTag\u9519", "TAG_INSTANCE_ERROR"));
        errorLocalMap.put("NATIVE_CALL_INVALID", ErrorInfo.concat("\u672c\u5730\u8c03\u7528\u4e0d\u5408\u6cd5\uff0c\u627e\u4e0d\u5230\u7c7b\u6216\u8005\u65b9\u6cd5", "NATIVE_CALL_INVALID"));
        errorLocalMap.put("NATIVE_CALL_EXCEPTION", ErrorInfo.concat("\u8c03\u7528\u65b9\u6cd5\u629b\u51fa\u4e86\u5f02\u5e38", "NATIVE_CALL_EXCEPTION"));
        errorLocalMap.put("NATIVE_SECUARITY_EXCEPTION", ErrorInfo.concat("\u5b89\u5168\u7ba1\u7406\u5668\u4e0d\u5141\u8bb8\u7684\u672c\u5730\u8c03\u7528", "NATIVE_SECUARITY_EXCEPTION"));
        errorLocalMap.put("FORMAT_NOT_FOUND", ErrorInfo.concat("\u672a\u6ce8\u518c\u7684\u683c\u5f0f\u5316\u51fd\u6570", "FORMAT_NOT_FOUND"));
        errorLocalMap.put("DEFAULT_FORMAT_NOT_FOUND", ErrorInfo.concat("\u7c7b\u578b\u672a\u6709\u5bf9\u5e94\u7684\u9ed8\u8ba4\u7684\u683c\u5f0f\u5316\u51fd\u6570", "DEFAULT_FORMAT_NOT_FOUND"));
        errorLocalMap.put("ATTRIBUTE_INVALID", ErrorInfo.concat("\u5c5e\u6027\u83b7\u53d6\u5f02\u5e38", "ATTRIBUTE_INVALID"));
        errorLocalMap.put("ATTRIBUTE_NOT_FOUND", ErrorInfo.concat("\u672a\u627e\u5230\u5c5e\u6027", "ATTRIBUTE_NOT_FOUND"));
        errorLocalMap.put("CAST_LIST_OR_MAP_ERROR", ErrorInfo.concat("\u6a21\u677f\u91cc\u4f7f\u7528\u4e86[]\u6307\u793a\u5e94\u8be5\u662fMap\u6216\u8005List\uff0c\u4f46\u5b9e\u9645\u4e0a\u4e0d\u662f\u6b64\u7c7b\u578b", "CAST_LIST_OR_MAP_ERROR"));
        errorLocalMap.put("ATTRIBUTE_NOT_FOUND", ErrorInfo.concat("\u672a\u627e\u5230\u5c5e\u6027", "ATTRIBUTE_NOT_FOUND"));
        errorLocalMap.put("NULL", ErrorInfo.concat("\u8868\u8fbe\u5f0f\u503c\u4e3a\u7a7a", "NULL"));
        errorLocalMap.put("DIV_ZERO_ERROR", ErrorInfo.concat("\u96640\u9519\u8bef", "DIV_ZERO_ERROR"));
        errorLocalMap.put("ARRAY_INDEX_ERROR", ErrorInfo.concat("\u6570\u7ec4index\u9519", "ARRAY_INDEX_ERROR"));
        errorLocalMap.put("ARRAY_TYPE_ERROR", ErrorInfo.concat("\u672c\u5730\u8c03\u7528[] \u671f\u671b\u7c7b\u578b\u662f\u6570\u7ec4", "ARRAY_TYPE_ERROR"));
        errorLocalMap.put("BOOLEAN_EXPECTED_ERROR", ErrorInfo.concat("\u671f\u671b\u4e3aBoolean\u7c7b\u578b", "BOOLEAN_EXPECTED_ERROR"));
        errorLocalMap.put("COLLECTION_EXPECTED_ERROR", ErrorInfo.concat("\u671f\u671b\u904d\u5386\u76ee\u6807\u662f\u662f\u96c6\u5408\uff0c\u6570\u7ec4\uff0cIterator\uff0cIterable", "COLLECTION_EXPECTED_ERROR"));
        errorLocalMap.put("NUMBER_EXPECTED_ERROR", ErrorInfo.concat("\u671f\u671b\u662f\u6570\u5b57\u7c7b\u578b", "NUMBER_EXPECTED_ERROR"));
        errorLocalMap.put("STRICK_MVC", ErrorInfo.concat("\u4e25\u683cMVC\uff0c\u4e0d\u5141\u8bb8\u7684\u8bed\u6cd5", "STRICK_MVC"));
        errorLocalMap.put("NATIVE_NOT_ALLOWED", ErrorInfo.concat("\u672c\u5730\u8c03\u7528\u4e0d\u5141\u8bb8", "NATIVE_NOT_ALLOWED"));
        errorLocalMap.put("GET_CALL_ERROR", ErrorInfo.concat("\u5c5e\u6027\u83b7\u53d6\u9519\u8bef", "GET_CALL_ERROR"));
        errorLocalMap.put("TOKEN_ERROR", ErrorInfo.concat("\u8bcd\u6cd5\u9519\u8bef", "TOKEN_ERROR"));
        errorLocalMap.put("PARSER_HTML_TAG_ERROR", ErrorInfo.concat("\u89e3\u6790HTML\u6807\u7b7e\u51fa\u9519", "PARSER_HTML_TAG_ERROR"));
        errorLocalMap.put("PARSER_UNKNOW_ERROR", ErrorInfo.concat("\u8bed\u6cd5\u9519\u8bef", "PARSER_UNKNOW_ERROR"));
        errorLocalMap.put("PARSER_VIABLE_ERROR", ErrorInfo.concat("\u8bed\u6cd5\u9519\u8bef", "PARSER_VIABLE_ERROR"));
        errorLocalMap.put("PARSER_MISS_ERROR", ErrorInfo.concat("\u7f3a\u5c11\u7b26\u53f7", "PARSER_MISS_ERROR"));
        errorLocalMap.put("PARSER_PREDICATE_ERROR", ErrorInfo.concat("\u8bed\u6cd5\u9519\u8bef", "PARSER_PREDICATE_ERROR"));
        errorLocalMap.put("TYPE_SEARCH_ERROR", ErrorInfo.concat("\u672a\u627e\u5230\u6307\u5b9a\u7c7b\u578b\uff0c\u8bf7\u914d\u7f6e\u7c7b\u641c\u7d22\u8def\u5f84\u6216\u8005\u589e\u52a0\u7c7b\u5305\u540d", "TYPE_SEARCH_ERROR"));
        errorLocalMap.put("PARSER_NATIVE_ERROR", ErrorInfo.concat("\u672c\u5730\u8c03\u7528\u683c\u5f0f\u51fa\u9519\uff0c\u4e0d\u5141\u8bb8\u6b64\u683c\u5f0f", "PARSER_NATIVE_ERROR"));
        errorLocalMap.put("TEMPLATE_LOAD_ERROR", ErrorInfo.concat("\u9519\u627e\u4e0d\u5230\u6307\u5b9a\u6a21\u677f\u6216\u8005\u52a0\u8f7d\u9519", "TEMPLATE_LOAD_ERROR"));
        errorLocalMap.put("CLIENT_IO_ERROR_ERROR", ErrorInfo.concat("\u5ba2\u6237\u7aefIO\u51fa\u9519", "CLIENT_IO_ERROR_ERROR"));
        errorLocalMap.put("EXPRESSION_NOT_COMPATIBLE", ErrorInfo.concat("\u8868\u8fbe\u5f0f\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u8fd0\u7b97", "EXPRESSION_NOT_COMPATIBLE"));
        errorLocalMap.put("AJAX_ALREADY_DEFINED", ErrorInfo.concat("Ajax \u951a\u70b9\u5df2\u7ecf\u5b9a\u4e49", "AJAX_ALREADY_DEFINED"));
        errorLocalMap.put("AJAX_NOT_FOUND", ErrorInfo.concat("Ajax \u951a\u70b9\u672a\u5b9a\u4e49", "AJAX_NOT_FOUND"));
        errorLocalMap.put("AJAX_PROPERTY_ERROR", ErrorInfo.concat("Ajax \u5c5e\u6027\u8bbe\u7f6e\u9519\u8bef", "AJAX_PROPERTY_ERROR"));
    }
}

