/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.Tag;
import org.beetl.core.TagFactory;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.ObjectUtil;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;

public class TagStatement
extends Statement {
    String tagName;
    public Expression[] paras;
    public Statement block;

    public TagStatement(String tagName, Expression[] paras, Statement block, GrammarToken token) {
        super(token);
        this.tagName = tagName;
        this.paras = paras;
        this.block = block;
    }

    @Override
    public void execute(Context ctx) {
        Tag tag = null;
        try {
            TagFactory tagFactory = ctx.gt.getTagFactory(this.tagName);
            tag = tagFactory.createTag();
            Object[] args = null;
            if (this.paras.length == 0) {
                args = ObjectUtil.EMPTY_OBJECT_ARRAY;
            } else {
                args = new Object[this.paras.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.paras[i].evaluate(ctx);
                }
            }
            tag.init(ctx, args, this.block);
            this.runTag(tag, ctx);
        }
        catch (BeetlException ex) {
            if (!ex.inTagBody) {
                ex.pushToken(this.token);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException bex = new BeetlException("TAG_INSTANCE_ERROR", ex.getMessage(), ex);
            bex.pushToken(this.token);
            throw bex;
        }
    }

    protected void runTag(Tag tag, Context ctx) {
        try {
            tag.render();
        }
        catch (BeetlException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException be = new BeetlException("ERROR", "tag\u6267\u884c\u629b\u9519", ex);
            be.pushToken(this.token);
            throw be;
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        for (Expression exp : this.paras) {
            exp.infer(inferCtx);
        }
        this.block.infer(inferCtx);
    }
}

