/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Type;

public class TernaryExpression
extends Expression {
    public Expression condtion;
    public Expression a;
    public Expression b;

    public TernaryExpression(Expression condtion, Expression a, Expression b, GrammarToken token) {
        super(token);
        this.condtion = condtion;
        this.a = a;
        this.b = b;
    }

    @Override
    public Object evaluate(Context ctx) {
        Object value = this.condtion.evaluate(ctx);
        if (value == null) {
            BeetlException be = new BeetlException("NULL");
            be.pushToken(this.condtion.token);
            throw be;
        }
        if (!(value instanceof Boolean)) {
            BeetlException be = new BeetlException("BOOLEAN_EXPECTED_ERROR");
            be.pushToken(this.condtion.token);
            throw be;
        }
        boolean cond = (Boolean)value;
        if (cond) {
            return this.a.evaluate(ctx);
        }
        if (this.b != null) {
            return this.b.evaluate(ctx);
        }
        return null;
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.condtion.infer(inferCtx);
        if (this.a != null) {
            this.a.infer(inferCtx);
            if (this.b == null) {
                this.type = this.a.type;
                return;
            }
        }
        if (this.b != null) {
            this.b.infer(inferCtx);
            if (this.a == null) {
                this.type = this.b.type;
                return;
            }
        }
        this.type = this.a.type.equals(this.b.type) ? this.a.type : Type.ObjectType;
    }
}

