/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import org.beetl.core.BodyContent;
import org.beetl.core.Context;
import org.beetl.core.ContextBuffer;
import org.beetl.core.io.FloatingIOWriter;
import org.beetl.core.io.IntIOWriter;
import org.beetl.core.io.LongIOWriter;

public abstract class ByteWriter {
    protected ContextBuffer localBuffer = null;
    protected Context ctx = null;
    protected ByteWriter parent;

    public ByteWriter(Context ctx) {
        this.ctx = ctx;
        this.localBuffer = ctx.localBuffer;
    }

    public abstract void write(char[] var1) throws IOException;

    public abstract void write(char[] var1, int var2) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    public abstract void writeNumberChars(char[] var1, int var2) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void write(byte[] var1, int var2) throws IOException;

    public abstract ByteWriter getTempWriter(ByteWriter var1);

    public abstract BodyContent getTempConent();

    public abstract void fill(ByteWriter var1) throws IOException;

    public abstract void flush() throws IOException;

    public void write(BodyContent bodyContent) throws IOException {
        bodyContent.fill(this);
    }

    public void writeDouble(Double d) throws IOException {
        FloatingIOWriter fd = new FloatingIOWriter(d);
        fd.write(this, this.localBuffer.getCharBuffer());
    }

    public void writeFloat(Float d) throws IOException {
        FloatingIOWriter fd = new FloatingIOWriter(d.floatValue());
        fd.write(this, this.localBuffer.getCharBuffer());
    }

    public void writeInteger(Integer i) throws IOException {
        IntIOWriter.writeInteger(this, i);
    }

    public void writeShort(Short i) throws IOException {
        IntIOWriter.writeShort(this, i);
    }

    public void writeLong(Long i) throws IOException {
        LongIOWriter.writeLong(this, i);
    }

    public void writeObject(Object o) throws IOException {
        if (o != null) {
            this.writeString(o.toString());
        }
    }

    public ContextBuffer getLocalBuffer() {
        return this.localBuffer;
    }

    public ByteWriter getParent() {
        return this.parent;
    }
}

