/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

public class ContextBuffer {
    public static int minSize;
    public static int charBufferSize;
    public static int byteBufferSize;
    private static char[] EMPTY_CHAR_ARRAY;
    private static byte[] EMPTY_BYTE_ARRAY;
    int maxSize = 0;
    boolean inner = true;
    private char[] charBuffer = new char[charBufferSize];
    private byte[] byteBuffer = new byte[byteBufferSize];

    public ContextBuffer(int maxSize, boolean inner) {
        this(maxSize);
        this.inner = inner;
    }

    public ContextBuffer(int maxSize) {
        if (maxSize < minSize) {
            throw new IllegalArgumentException("buffer\u671f\u671b\u8bbe\u7f6e\u9700\u8981\u5927\u4e8e " + minSize);
        }
        this.maxSize = maxSize;
    }

    public char[] getCharBuffer() {
        return this.charBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public char[] getCharBuffer(int expected) {
        if (this.charBuffer.length >= expected) {
            return this.charBuffer;
        }
        if (expected >= this.maxSize) {
            return EMPTY_CHAR_ARRAY;
        }
        this.charBuffer = new char[(int)((double)expected * 1.2)];
        return this.charBuffer;
    }

    public byte[] getByteBuffer(int expected) {
        if (this.byteBuffer.length >= expected) {
            return this.byteBuffer;
        }
        if (expected < this.maxSize) {
            this.byteBuffer = new byte[(int)((double)expected * 1.2)];
            return this.byteBuffer;
        }
        return EMPTY_BYTE_ARRAY;
    }

    static {
        charBufferSize = minSize = 256;
        byteBufferSize = minSize;
        EMPTY_CHAR_ARRAY = new char[0];
        EMPTY_BYTE_ARRAY = new byte[0];
    }
}

