/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import java.io.OutputStream;
import org.beetl.core.BodyContent;
import org.beetl.core.ByteWriter;
import org.beetl.core.Context;
import org.beetl.core.io.ByteBodyContent;
import org.beetl.core.io.DefaultEncoder;
import org.beetl.core.io.NoLockByteArrayOutputStream;

public class ByteWriter_Byte
extends ByteWriter {
    protected OutputStream os;
    protected String cs;
    DefaultEncoder encode = null;

    public ByteWriter_Byte(OutputStream os, String cs, Context ctx) {
        super(ctx);
        this.os = os;
        this.cs = cs;
        this.encode = new DefaultEncoder(cs, this.localBuffer);
    }

    public ByteWriter_Byte(OutputStream os, String cs, Context ctx, ByteWriter parent) {
        this(os, cs, ctx);
        this.parent = parent;
    }

    @Override
    public final void write(char[] cbuf) throws IOException {
        this.write(cbuf, cbuf.length);
    }

    @Override
    public final void write(char[] cbuf, int len) throws IOException {
        byte[] bs = new String(cbuf, 0, len).getBytes(this.cs);
        this.write(bs);
    }

    @Override
    public final void write(byte[] bs) throws IOException {
        this.os.write(bs);
    }

    @Override
    public void write(byte[] bs, int count) throws IOException {
        this.os.write(bs, 0, count);
    }

    @Override
    public void writeString(String str) throws IOException {
        if (str != null) {
            this.encode.write(str, this.os);
        }
    }

    @Override
    public ByteWriter getTempWriter(ByteWriter parent) {
        return new ByteWriter_Byte(new NoLockByteArrayOutputStream(), this.cs, this.ctx, parent);
    }

    @Override
    public void flush() throws IOException {
        if (this.parent != null) {
            this.parent.flush();
        }
        this.os.flush();
    }

    @Override
    public void fill(ByteWriter bw) throws IOException {
        ByteWriter_Byte bwb = (ByteWriter_Byte)bw;
        NoLockByteArrayOutputStream byteArray = (NoLockByteArrayOutputStream)bwb.os;
        this.write(byteArray.buf, byteArray.count);
    }

    @Override
    public BodyContent getTempConent() {
        NoLockByteArrayOutputStream byteArray = (NoLockByteArrayOutputStream)this.os;
        return new ByteBodyContent(byteArray.buf, byteArray.count, this.cs);
    }

    public OutputStream getOs() {
        return this.os;
    }

    public void setOs(OutputStream os) {
        this.os = os;
    }

    public String getCs() {
        return this.cs;
    }

    public void setCs(String cs) {
        this.cs = cs;
    }

    @Override
    public void writeNumberChars(char[] chars, int len) throws IOException {
        byte[] bs = this.ctx.localBuffer.getByteBuffer(len);
        for (int i = 0; i < len; ++i) {
            bs[i] = (byte)chars[i];
        }
        this.os.write(bs, 0, len);
    }
}

