/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.fun;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.FunctionWrapper;
import org.beetl.core.fun.ObjectUtil;

public class SingleFunctionWrapper
extends FunctionWrapper {
    Method m;

    public SingleFunctionWrapper(String funName, Class cls, Object target, Method m) {
        super(funName);
        this.target = target;
        this.cls = cls;
        this.m = m;
        this.requiredContext = this.checkContextRequried(m.getParameterTypes());
    }

    @Override
    public Object call(Object[] paras, Context ctx) {
        try {
            if (!this.requiredContext) {
                if (this.target != null) {
                    return ObjectUtil.invokeObject(this.target, this.m.getName(), paras);
                }
                return ObjectUtil.invokeStatic(this.cls, this.m.getName(), paras);
            }
            Object[] newParas = this.getContextParas(paras, ctx);
            if (this.target != null) {
                return ObjectUtil.invokeObject(this.target, this.m.getName(), newParas);
            }
            return ObjectUtil.invokeStatic(this.cls, this.m.getName(), newParas);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof BeetlException) {
                throw (BeetlException)t;
            }
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u65b9\u6cd5\u51fa\u9519 " + this.functionName, t);
        }
        catch (BeetlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u65b9\u6cd5\u51fa\u9519 " + this.functionName, ex);
        }
    }

    public Class getReturnType() {
        return this.m.getReturnType();
    }
}

