/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import org.beetl.core.text.CRFragment;
import org.beetl.core.text.Fragment;
import org.beetl.core.text.HtmlTagEndFragment;
import org.beetl.core.text.HtmlTagStartFragment;
import org.beetl.core.text.PlaceHolderFragment;
import org.beetl.core.text.ScriptBlockFragment;
import org.beetl.core.text.Source;

public class TextFragment
extends Fragment {
    StringBuilder text = new StringBuilder();
    boolean hasText = false;
    int crCount = 0;

    public TextFragment(Source source) {
        super(source);
        this.endLine = this.startLine;
        source.lastTextFragment = this;
    }

    public void appendTextFragment(Fragment fr) {
        if (fr instanceof TextFragment) {
            this.text.append((CharSequence)((TextFragment)fr).text);
        } else if (fr instanceof CRFragment) {
            this.text.append(((CRFragment)fr).cr);
            ++this.crCount;
        } else {
            throw new IllegalArgumentException(fr.getClass().getName());
        }
    }

    @Override
    public StringBuilder getScript() {
        StringBuilder script = new StringBuilder();
        if (this.text.length() == 0) {
            return script;
        }
        Integer varName = this.source.getParser().getRandomeTextVarName();
        script.append("<$").append(varName).append(">>");
        for (int i = 0; i < this.crCount; ++i) {
            script.append('\n');
        }
        this.source.parser.getTextVars().put(varName, this.text.toString());
        return script;
    }

    @Override
    public Fragment consumeAndReturnNext() {
        while (!this.source.isEof()) {
            if (this.source.isPlaceHolderStart()) {
                this.setEndLine();
                return new PlaceHolderFragment(this.source);
            }
            if (this.source.isScriptStart()) {
                this.setEndLine();
                return new ScriptBlockFragment(this.source);
            }
            if (this.source.isHtmlTagStart()) {
                this.setEndLine();
                return new HtmlTagStartFragment(this.source);
            }
            if (this.source.isHtmlTagEnd()) {
                this.setEndLine();
                return new HtmlTagEndFragment(this.source);
            }
            if (this.source.isCrStart()) {
                return new CRFragment(this.source);
            }
            char c = this.source.consumeAndGet();
            this.text.append(c);
        }
        return null;
    }

    public boolean onlySpace() {
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    public void removeTextEscape() {
        this.text.setLength(this.text.length() - 1);
    }
}

