/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.nutz;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.beetl.core.ConsoleErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.exception.BeetlException;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class LogErrorHandler
extends ConsoleErrorHandler {
    private static final Log log = Logs.get();
    protected ThreadLocal<StringBuilder> sb = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processException(BeetlException ex, GroupTemplate groupTemplate, Writer writer) {
        StringBuilder _sb = new StringBuilder();
        try {
            this.sb.set(_sb);
            if (ex != null) {
                _sb.append(ex.getMessage()).append("\n");
                ex.printStackTrace();
            }
            super.processException(ex, groupTemplate, writer);
            log.debug((Object)_sb);
        }
        finally {
            this.sb.set(null);
        }
    }

    @Override
    protected void println(Writer w, String msg) {
        this.sb.get().append(msg).append('\n');
    }

    @Override
    protected void print(Writer w, String msg) {
        this.sb.get().append(msg);
    }

    @Override
    protected void printThrowable(Writer w, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        this.sb.get().append(sw.getBuffer()).append("\n");
    }
}

