/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.jfinal;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.sql.DataSource;

class C3p0Source {
    private String jdbcUrl;
    private String user;
    private String password;
    private String driverClass = "com.mysql.jdbc.Driver";
    private int maxPoolSize = 100;
    private int minPoolSize = 10;
    private int initialPoolSize = 10;
    private int maxIdleTime = 20;
    private int acquireIncrement = 2;
    private ComboPooledDataSource dataSource;

    public C3p0Source(Properties properties) {
        Properties ps = properties;
        this.initC3p0Properties(ps.getProperty("jdbcUrl"), ps.getProperty("user"), ps.getProperty("password"), ps.getProperty("driverClass"), this.toInt(ps.getProperty("maxPoolSize", "5")), this.toInt(ps.getProperty("minPoolSize", "5")), this.toInt(ps.getProperty("initialPoolSize", "5")), this.toInt(ps.getProperty("maxIdleTime", "20")), this.toInt(ps.getProperty("acquireIncrement", "5")));
    }

    private void initC3p0Properties(String jdbcUrl, String user, String password, String driverClass, Integer maxPoolSize, Integer minPoolSize, Integer initialPoolSize, Integer maxIdleTime, Integer acquireIncrement) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
        this.driverClass = driverClass != null ? driverClass : this.driverClass;
        this.maxPoolSize = maxPoolSize != null ? maxPoolSize : this.maxPoolSize;
        this.minPoolSize = minPoolSize != null ? minPoolSize : this.minPoolSize;
        this.initialPoolSize = initialPoolSize != null ? initialPoolSize : this.initialPoolSize;
        this.maxIdleTime = maxIdleTime != null ? maxIdleTime : this.maxIdleTime;
        this.acquireIncrement = acquireIncrement != null ? acquireIncrement : this.acquireIncrement;
    }

    public boolean start() {
        this.dataSource = new ComboPooledDataSource();
        this.dataSource.setJdbcUrl(this.jdbcUrl);
        this.dataSource.setUser(this.user);
        this.dataSource.setPassword(this.password);
        try {
            this.dataSource.setDriverClass(this.driverClass);
        }
        catch (PropertyVetoException e) {
            this.dataSource = null;
            System.err.println("C3p0Plugin start error");
            throw new RuntimeException(e);
        }
        this.dataSource.setMaxPoolSize(this.maxPoolSize);
        this.dataSource.setMinPoolSize(this.minPoolSize);
        this.dataSource.setInitialPoolSize(this.initialPoolSize);
        this.dataSource.setMaxIdleTime(this.maxIdleTime);
        this.dataSource.setAcquireIncrement(this.acquireIncrement);
        return true;
    }

    private Integer toInt(String str) {
        return Integer.parseInt(str);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean stop() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        return true;
    }
}

