/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.annotatoin.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.annotatoin.builder.BaseAttributeBuilder;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.mapping.type.TypeParameter;

public class SampleJsonAtrributeBuilder
extends BaseAttributeBuilder {
    public static ObjectMapper mapper = new ObjectMapper();
    public static Jackson json = new Jackson();

    @Override
    public Object toObject(SQLManager sqlManager, Annotation an, String sqlId, TypeParameter typeParameter, PropertyDescriptor property) throws SQLException {
        if (typeParameter.getRs().wasNull()) {
            return null;
        }
        String data = typeParameter.getRs().getString(typeParameter.getIndex());
        if (data == null) {
            return null;
        }
        try {
            Class<?> retType = property.getReadMethod().getReturnType();
            Type pt = property.getReadMethod().getGenericReturnType();
            if (pt instanceof ParameterizedType) {
                JavaType jacksonType = SampleJsonAtrributeBuilder.parameterizedType(retType, pt);
                return mapper.readValue(data, jacksonType);
            }
            return mapper.readValue(data, retType);
        }
        catch (IOException e) {
            throw new SQLException("beetlsql \u65e0\u6cd5\u8f6c\u5316\u4e3ajson:" + data, e);
        }
    }

    @Override
    public String toSql(AbstractDBStyle dbStyle, String fieldName, String colName, Annotation an, TableDesc tableDesc) {
        return "jackson(" + fieldName + ")";
    }

    static JavaType parameterizedType(Class c, Type pt) {
        if (pt instanceof ParameterizedType) {
            Type[] tv = ((ParameterizedType)pt).getActualTypeArguments();
            Class[] types = new Class[tv.length];
            for (int i = 0; i < tv.length; ++i) {
                types[i] = (Class)tv[i];
            }
            return SampleJsonAtrributeBuilder.getCollectionType(c, types);
        }
        throw new IllegalStateException(pt.toString());
    }

    static JavaType getCollectionType(Class collectionClass, Class[] elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }

    static class Jackson
    implements Function {
        Jackson() {
        }

        public String call(Object[] paras, Context ctx) {
            Object o = paras[0];
            if (o == null) {
                return null;
            }
            try {
                return mapper.writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("\u5e8f\u5217\u5316\u5931\u8d25 " + o, e);
            }
        }
    }
}

