/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.annotatoin.Builder;
import org.beetl.sql.core.annotatoin.ColumnIgnore;
import org.beetl.sql.core.annotatoin.InsertIgnore;
import org.beetl.sql.core.annotatoin.LogicDelete;
import org.beetl.sql.core.annotatoin.UpdateIgnore;
import org.beetl.sql.core.annotatoin.Version;
import org.beetl.sql.core.annotatoin.builder.AttributeBuilderHolder;
import org.beetl.sql.core.annotatoin.builder.ObjectBuilderHolder;
import org.beetl.sql.core.annotatoin.builder.ObjectPersistBuilder;
import org.beetl.sql.core.annotatoin.builder.ObjectSelectBuilder;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;

public class ClassAnnotation {
    static Map<Class, ClassAnnotation> cache = new ConcurrentHashMap<Class, ClassAnnotation>();
    Class entity = null;
    Map<String, ClassDesc.ColumnIgnoreStatus> attrIgnores = new HashMap<String, ClassDesc.ColumnIgnoreStatus>();
    String logicDeleteAttrName = null;
    int logicDeleteAttrValue = 0;
    String versionProperty;
    int initVersionValue = -1;
    CaseInsensitiveHashMap<String, AttributeBuilderHolder> colHandlers = new CaseInsensitiveHashMap();
    List<ObjectBuilderHolder> objectBuilders = new ArrayList<ObjectBuilderHolder>();

    public static ClassAnnotation getClassAnnotation(Class entity) {
        ClassAnnotation ca = cache.get(entity);
        if (ca != null) {
            return ca;
        }
        ca = new ClassAnnotation(entity);
        ca.init();
        cache.put(entity, ca);
        return ca;
    }

    protected ClassAnnotation(Class entity) {
        this.entity = entity;
    }

    protected void init() {
        this.typeCheck();
        this.propertyCheck();
    }

    protected void typeCheck() {
        Annotation[] ans = this.entity.getAnnotations();
        ArrayList<ObjectBuilderHolder> list = new ArrayList<ObjectBuilderHolder>();
        for (Annotation an : ans) {
            Builder builder = an.annotationType().getAnnotation(Builder.class);
            if (builder == null) continue;
            Class clz = builder.value();
            Object obj = BeanKit.newInstance(clz);
            if (!(obj instanceof ObjectPersistBuilder) && !(obj instanceof ObjectSelectBuilder)) {
                throw new BeetlSQLException(23, this.entity + " \u7684\u6ce8\u89e3 " + an + "  \u7684value\u503c\u5fc5\u987b\u662f BaseObjectBuilder\u5b50\u7c7b");
            }
            ObjectBuilderHolder holder = new ObjectBuilderHolder(an, builder);
            list.add(holder);
        }
        this.objectBuilders.addAll(list);
    }

    protected void propertyCheck() {
        PropertyDescriptor[] ps;
        for (PropertyDescriptor p : ps = this.getPropertyDescriptor()) {
            AttributeBuilderHolder holder;
            Version version;
            Method readMethod = p.getReadMethod();
            ColumnIgnore sqlIgnore = BeanKit.getAnnoation(this.entity, p.getName(), readMethod, ColumnIgnore.class);
            if (sqlIgnore != null) {
                this.attrIgnores.put(p.getName(), new ClassDesc.ColumnIgnoreStatus(sqlIgnore));
            } else {
                InsertIgnore ig = BeanKit.getAnnoation(this.entity, p.getName(), readMethod, InsertIgnore.class);
                UpdateIgnore ug = BeanKit.getAnnoation(this.entity, p.getName(), readMethod, UpdateIgnore.class);
                if (ig != null || ug != null) {
                    this.attrIgnores.put(p.getName(), new ClassDesc.ColumnIgnoreStatus(ig, ug));
                }
            }
            LogicDelete logicDelete = BeanKit.getAnnoation(this.entity, p.getName(), readMethod, LogicDelete.class);
            if (logicDelete != null) {
                this.logicDeleteAttrName = p.getName();
                this.logicDeleteAttrValue = logicDelete.value();
            }
            if ((version = BeanKit.getAnnoation(this.entity, p.getName(), readMethod, Version.class)) != null) {
                this.versionProperty = p.getName();
                this.initVersionValue = version.value();
            }
            if ((holder = BeanKit.getAttributeHanlderHolder(this.entity, p.getName(), p)) == null) continue;
            this.colHandlers.put(p.getName(), (Object)holder);
        }
    }

    public PropertyDescriptor[] getPropertyDescriptor() {
        try {
            return BeanKit.propertyDescriptors(this.entity);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public InsertIgnore getInsertIgnore(String property) {
        return null;
    }

    public CaseInsensitiveHashMap<String, AttributeBuilderHolder> getColHandlers() {
        return this.colHandlers;
    }

    public Class getEntity() {
        return this.entity;
    }

    public Map<String, ClassDesc.ColumnIgnoreStatus> getAttrIgnores() {
        return this.attrIgnores;
    }

    public String getLogicDeleteAttrName() {
        return this.logicDeleteAttrName;
    }

    public int getLogicDeleteAttrValue() {
        return this.logicDeleteAttrValue;
    }

    public String getVersionProperty() {
        return this.versionProperty;
    }

    public List<ObjectBuilderHolder> getObjectBuilders() {
        return this.objectBuilders;
    }

    public void setObjectBuilders(List<ObjectBuilderHolder> objectBuilders) {
        this.objectBuilders = objectBuilders;
    }
}

