/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import com.alibaba.druid.pool.DruidDataSource;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.sql.DataSource;
import org.beetl.core.Function;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.annotatoin.builder.SampleJsonAtrributeBuilder;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.test.MysqlDBConfig;
import org.beetl.sql.test.User;
import org.beetl.sql.test.UserDao;

public class QuickTest {
    static ObjectMapper mapper = new ObjectMapper();
    public List list = null;

    public static void main(String[] args) throws Exception {
        MySqlStyle style = new MySqlStyle();
        ConnectionSource cs = ConnectionSourceHelper.getSingle(QuickTest.datasource());
        ClasspathLoader loader = new ClasspathLoader("/sql");
        DebugInterceptor debug = new DebugInterceptor();
        Interceptor[] inters = new Interceptor[]{debug};
        SQLManager sql = new SQLManager(style, loader, cs, new UnderlinedNameConversion(), inters);
        sql.getBeetl().getGroupTemplate().registerFunction("jackson", (Function)SampleJsonAtrributeBuilder.json);
        sql.addIdAutonGen("test", new IDAutoGen(){
            int i = 0;

            public Object nextID(String params) {
                return this.i++;
            }
        });
        MyPageQuery query = new MyPageQuery();
        User user = new User();
        user.setId(20);
        query.setParas(user);
        User user2 = new User();
        user2.setId(10);
        UserDao dao = sql.getMapper(UserDao.class);
        dao.pageQuery(query, user2);
    }

    public static JavaType parameterizedType(Class c, Type pt) {
        if (pt instanceof ParameterizedType) {
            Type[] tv = ((ParameterizedType)pt).getActualTypeArguments();
            Class[] types = new Class[tv.length];
            for (int i = 0; i < tv.length; ++i) {
                types[i] = (Class)tv[i];
            }
            return QuickTest.getCollectionType(c, types);
        }
        throw new IllegalStateException(pt.toString());
    }

    public static JavaType getCollectionType(Class collectionClass, Class[] elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }

    public static User unique(SQLManager sql, Object key) {
        return sql.unique(User.class, key);
    }

    public static DataSource datasource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(MysqlDBConfig.url);
        ds.setUsername(MysqlDBConfig.userName);
        ds.setPassword(MysqlDBConfig.password);
        ds.setDriverClassName(MysqlDBConfig.driver);
        return ds;
    }

    public static DataSource druidSource() {
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(MysqlDBConfig.url);
        ds.setUsername(MysqlDBConfig.userName);
        ds.setPassword(MysqlDBConfig.password);
        ds.setDriverClassName(MysqlDBConfig.driver);
        return ds;
    }

    static class MyPageQuery<T>
    extends PageQuery {
        private static final long serialVersionUID = 6114194234926721407L;

        MyPageQuery() {
        }

        @Override
        public void setParas(Object paras) {
            super.setParas(paras);
        }

        @Override
        public void setOrderBy(String orderBy) {
            super.setOrderBy(orderBy);
        }
    }
}

