/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mysql;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.mysql.MyUserMapper;

public class MysqlTest {
    public static void main(String[] args) {
        DataSource dataSource = MysqlTest.datasource();
        ConnectionSource source = ConnectionSourceHelper.getSingle((DataSource)dataSource);
        SQLManagerBuilder builder = new SQLManagerBuilder(source);
        builder.setNc((NameConversion)new UnderlinedNameConversion());
        builder.setInters(new Interceptor[]{new DebugInterceptor()});
        builder.setDbStyle((DBStyle)new MySqlStyle());
        SQLManager sqlManager = builder.build();
        MyUserMapper userMapper = (MyUserMapper)sqlManager.getMapper(MyUserMapper.class);
        userMapper.select();
    }

    public static DataSource datasource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl("jdbc:mysql://127.0.0.1:13306/test?useUnicode=true&characterEncoding=UTF-8&serverTimezone=GMT%2B8");
        ds.setUsername("root");
        ds.setPassword("12345678");
        ds.setDriverClassName("com.mysql.cj.jdbc.Driver");
        return ds;
    }
}

