/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.postgres;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.clazz.kit.AutoSQLEnum;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.PostgresStyle;

public class JacksonConvert
implements AttributeConvert {
    ObjectMapper objectMapper = new ObjectMapper();

    public Object toDb(ExecuteContext ctx, Class cls, String name, Object dbValue) {
        Object obj = BeanKit.getBeanProperty((Object)dbValue, (String)name);
        if (obj == null) {
            return null;
        }
        try {
            String str = this.objectMapper.writeValueAsString(obj);
            return str;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5e8f\u5217\u5316\u5bf9\u8c61  " + obj + " \u6765\u81ea\u4e8e " + dbValue.getClass() + " \u7684\u5c5e\u6027 " + name);
        }
    }

    public Object toAttr(ExecuteContext ctx, Class cls, String name, ResultSet rs, int index) throws SQLException {
        try {
            String json = rs.getString(index);
            if (StringKit.isEmpty((String)json)) {
                return null;
            }
            PropertyDescriptor ps = BeanKit.getPropertyDescriptor((Class)cls, (String)name);
            Class<?> retType = ps.getPropertyType();
            if (List.class.isAssignableFrom(retType)) {
                Type type = ps.getReadMethod().getGenericReturnType();
                Class listType = BeanKit.getCollectionType((Type)type);
                if (listType == null) {
                    return this.objectMapper.readValue(json, List.class);
                }
                return this.objectMapper.readValue(json, this.getCollectionType(List.class, listType));
            }
            if (Map.class.isAssignableFrom(retType)) {
                Type type = ps.getReadMethod().getGenericReturnType();
                Class[] mapType = BeanKit.getMapParameterTypeClass((Type)type);
                if (mapType == null) {
                    return this.objectMapper.readValue(json, List.class);
                }
                return this.objectMapper.readValue(json, this.getCollectionType(List.class, mapType));
            }
            return this.objectMapper.readValue(json, retType);
        }
        catch (JsonParseException ex) {
            throw new IllegalStateException(ex);
        }
        catch (JsonMappingException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return this.objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public String toAutoSqlPart(DBStyle dbStyle, Class cls, AutoSQLEnum autoSQLEnum, String name) {
        if (dbStyle instanceof PostgresStyle) {
            return "$$::JSON";
        }
        return null;
    }
}

