package org.beetl.sql.core.db;

import org.beetl.sql.clazz.kit.SpecialKeyWordHandler;
import org.beetl.sql.core.range.OffsetLimitRange;
import org.beetl.sql.core.range.RangeSql;

/**
 * 数据库差异：h2.
 *
 * @author zhoupan
 */
public class H2Style extends AbstractDBStyle {

    RangeSql rangeSql = null;
    public H2Style() {
        super();
        this.keyWordHandler = new SpecialKeyWordHandler();
        rangeSql = new OffsetLimitRange(this);
    }

    public String getPageSQL(String sql) {
        return sql + this.getOrderBy() + " \nlimit " + sqlTemplateEngine.appendVar(DBAutoGeneratedSql.OFFSET)+ " , " + sqlTemplateEngine.appendVar(DBAutoGeneratedSql.PAGE_SIZE);
    }


    @Override
    public String getName() {
        return "h2";
    }

    @Override
    public int getDBType() {
        return DBType.DB_H2;
    }

    @Override
    public RangeSql getRangeSql() {
        return rangeSql;
    }


	@Override
	public String getSeqValue(String seqName) {
		return "NEXT VALUE FOR "+seqName;
	}



}
