package org.beetl.sql.core.engine.template;

import org.beetl.sql.clazz.kit.Plugin;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.loader.SQLLoader;

import java.util.Properties;

/**
 * 模板引擎，可以采用其他模板引擎来执行sql模板，默认是用Beetl，
 * 因为Beetl的执行速度快，错误提示友好，最主要的原因是我写的:)
 *
 * @author xiandafu
 */
@Plugin
public interface SQLTemplateEngine {
    /**
     * 初始化模板引擎
     * @param loader
     * @param ps
     */
    public void init(SQLLoader loader, Properties ps);

    /**
     * 根据sqlId得到模板
     * @param id
     * @return
     */
    public SQLTemplate getSqlTemplate(SqlId id);

    /**
     * 模板渲染使用了include，包含别的sql片段
     * @param id
     * @param parent
     * @return
     */
    default SQLTemplate getSqlTemplate(SqlId id, TemplateContext parent){
        return getSqlTemplate(id);
    }


    /**
     * 校验模板是否正确
     * @param sqlTemplate
     * @return
     */
    public SQLErrorInfo validate(String sqlTemplate);


    /*DBAutoGeneratedSql代码生成需要借助模板引擎的语法*/

    /**
     * 输出一个变量，比如在beetl中，是#{}.
     * @param concatBuilder
     * @param var
     */
    public void genVar(ConcatBuilder concatBuilder,String var);

    public String appendVar(String epxression);

    /**
     * 输出一个trim，会去掉尾部多余的逗号,beetl中是
     * <pre>
     *     trim(){
     *
     *     }
     * </pre>
     * @param concatBuilder
     */
    void genTrimStart(ConcatBuilder concatBuilder);

	void genTrimStart(ConcatBuilder concatBuilder,String keyword);
    void genTrimEnd(ConcatBuilder concatBuilder);

    /**
     *
     * 输出一个if语句，用来判断变量是否为空
     * <pre>
     *     if(isNotEmpty(xxx)){
     *
     *     }
     * </pre>
     * @param concatBuilder
     * @param var
     */
    void genIfNotEmptyStart(ConcatBuilder concatBuilder,String var);
    void genIfNotEmptyEnd(ConcatBuilder concatBuilder);
    void genForStart(ConcatBuilder concatBuilder,String collection,String var);
	void genForEnd(ConcatBuilder concatBuilder);

    /**
     * 如果某个变量存在，且不为空，输出此变量
     * @param concatBuilder
     * @param var
     */
    public void genTestVar(ConcatBuilder concatBuilder,String var);
    /**
     * 如果某个变量存在，且不为空，输出列名
     * @param concatBuilder
     * @param var
     */
    void genTestVar(ConcatBuilder concatBuilder,String var,String col);


    void genTestVarOrDefault(ConcatBuilder concatBuilder,String var,String defaultValue);

    /**
     * 模板sql增加一一段字符串，需要考虑到str 不能包含模板的一些特殊符号，主要是定界符
     * @param str
     * @return
     * @see BeetlTemplateEngine#wrapString
     */
    default String wrapString(String str){
        return str;
    }

}
