/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.join;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.ResultSetMapper;
import org.beetl.sql.core.mapping.join.AttrNode;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;

public abstract class ConfigJoinMapper
implements ResultSetMapper {
    public List mapping(ExecuteContext ctx, Class target, ResultSet resultSet, Annotation config) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            AttrNode root = this.parse(ctx, target, resultSetMetaData, config);
            ReadTypeParameter rtp = new ReadTypeParameter(ctx.sqlId, ctx.sqlManager.getDbStyle().getName(), target, resultSet, resultSetMetaData, 1, ctx);
            RenderContext renderContext = new RenderContext();
            renderContext.beanProcessor = ctx.sqlManager.getDefaultBeanProcessors();
            while (resultSet.next()) {
                root.visit(renderContext, ctx, rtp);
            }
            if (renderContext.grid.gridValues.isEmpty()) {
                return new ArrayList();
            }
            List<NodeValue> nodeValues = renderContext.grid.getAll(root);
            return nodeValues.stream().map(nodeValue -> nodeValue.objectWrapper.realObject).collect(Collectors.toList());
        }
        catch (SQLException ex) {
            throw new BeetlSQLException(1, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new BeetlSQLException(1, (Throwable)ex);
        }
    }

    protected Map<String, Integer> getColumnIndex(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
        for (int col = 1; col <= count; ++col) {
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            map.put(columnName, col);
        }
        return map;
    }

    protected abstract AttrNode parse(ExecuteContext var1, Class var2, ResultSetMetaData var3, Annotation var4) throws Exception;

    static class Grid {
        Map<AttrNode, Set<Object>> gridKeys = new HashMap<AttrNode, Set<Object>>();
        Map<AttrNode, List<NodeValue>> gridValues = new HashMap<AttrNode, List<NodeValue>>();

        Grid() {
        }

        public void push(AttrNode node, NodeValue nodeValue) {
            Set<Object> cell = this.gridKeys.get(node);
            if (cell == null) {
                cell = new HashSet<Object>();
                this.gridKeys.put(node, cell);
                this.gridValues.put(node, new ArrayList());
            }
            if (!cell.contains(nodeValue.key)) {
                cell.add(nodeValue.key);
                List<NodeValue> nodeValueArrayList = this.gridValues.get(node);
                nodeValueArrayList.add(nodeValue);
            }
        }

        public boolean contain(AttrNode node, Object key) {
            Set<Object> set = this.gridKeys.get(node);
            if (set == null) {
                return false;
            }
            return set.contains(key);
        }

        public NodeValue getNodeValue(AttrNode node, Object key) {
            List<NodeValue> cell = this.gridValues.get(node);
            if (cell == null) {
                return null;
            }
            for (NodeValue nodeValue : cell) {
                if (nodeValue.key.hashCode() != key.hashCode() || !nodeValue.key.equals(key)) continue;
                return nodeValue;
            }
            return null;
        }

        public List<NodeValue> getAll(AttrNode node) {
            List<NodeValue> cell = this.gridValues.get(node);
            return cell;
        }
    }

    static class ObjectWrapper {
        Class target;
        Object realObject;
        NodeValue fromNodeValue;
        Map<PropertyDescriptor, Set> flagMap = new HashMap<PropertyDescriptor, Set>();

        ObjectWrapper() {
        }

        public void makeObject(Map<String, PropertyDescriptor> propertyMap) throws Exception {
            if (Map.class.isAssignableFrom(this.target)) {
                this.realObject = this.fromNodeValue.value;
            } else {
                Object obj = BeanKit.newInstance((Class)this.target);
                Map<String, Object> valueMap = this.fromNodeValue.value;
                for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                    String attr = entry.getKey();
                    Object value = entry.getValue();
                    PropertyDescriptor ps = propertyMap.get(attr);
                    try {
                        ps.getWriteMethod().invoke(obj, value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException(ps + " \u5c5e\u6027\u4e0d\u5339\u914d " + ps.getName() + " for " + value.getClass());
                    }
                }
                this.realObject = obj;
            }
            this.fromNodeValue.objectWrapper = this;
        }
    }

    static class NodeValue {
        Object key;
        Map<String, Object> value;
        ObjectWrapper objectWrapper;

        public NodeValue(Map values) {
            this.key = new TempKey(values);
            this.value = values;
        }

        public NodeValue(Object key, Map values) {
            this.key = key;
            this.value = values;
        }

        static class TempKey {
            Map<String, Object> value;
            int hashCode;

            public TempKey(Map<String, Object> value) {
                this.value = value;
                this.hashCode = value.hashCode();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TempKey tempKey = (TempKey)o;
                return this.value.equals(tempKey.value);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }

    static class RenderContext {
        Grid grid = new Grid();
        ObjectWrapper parent = null;
        BeanProcessor beanProcessor = null;

        RenderContext() {
        }
    }
}

