/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.type;

import java.io.Reader;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.beetl.sql.clazz.kit.LobKit;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;
import org.beetl.sql.core.mapping.type.WriteTypeParameter;

public class CharArrayTypeHandler
extends JavaSqlTypeHandler {
    @Override
    public Object getValue(ReadTypeParameter typePara) throws SQLException {
        ResultSet rs = typePara.rs;
        int index = typePara.index;
        if (typePara.dbName.equals("oracle")) {
            int type = typePara.meta.getColumnType(index);
            switch (type) {
                case 2005: {
                    Clob clob = rs.getClob(index);
                    if (clob == null) {
                        return null;
                    }
                    Reader r = clob.getCharacterStream();
                    return LobKit.getString((Reader)r).toCharArray();
                }
                case 2011: {
                    NClob nclob = rs.getNClob(index);
                    if (nclob == null) {
                        return null;
                    }
                    Reader r = nclob.getCharacterStream();
                    return LobKit.getString((Reader)r).toCharArray();
                }
            }
            return rs.getString(index).toCharArray();
        }
        return rs.getString(index).toCharArray();
    }

    @Override
    public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
        String str = new String((char[])obj);
        writeTypeParameter.getPs().setString(writeTypeParameter.getIndex(), str);
    }
}

