/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.page;

import java.util.List;
import org.beetl.sql.core.page.DefaultPageResult;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;

public class DefaultPageRequest<T>
implements PageRequest<T> {
    long pageNumber;
    int pageSize = 20;
    String orderBy;
    boolean totalRequired;
    boolean listRequired;

    public static PageRequest of(long page, int pageSize) {
        DefaultPageRequest request = new DefaultPageRequest();
        request.pageNumber = page;
        request.pageSize = pageSize;
        request.totalRequired = true;
        request.listRequired = true;
        return request;
    }

    public static PageRequest of(long page, int pageSize, boolean totalRequired) {
        DefaultPageRequest request = new DefaultPageRequest();
        request.pageNumber = page;
        request.pageSize = pageSize;
        request.totalRequired = totalRequired;
        request.listRequired = true;
        return request;
    }

    public static PageRequest of(long page, int pageSize, boolean totalRequired, boolean listRequired) {
        DefaultPageRequest request = new DefaultPageRequest();
        request.pageNumber = page;
        request.pageSize = pageSize;
        request.totalRequired = totalRequired;
        request.listRequired = listRequired;
        return request;
    }

    @Override
    public PageResult of(List<T> result) {
        DefaultPageResult<T> pageResult = new DefaultPageResult<T>();
        pageResult.setPage(this.pageNumber);
        pageResult.setPageSize(this.pageSize);
        pageResult.setList(result);
        pageResult.calcTotalPage();
        return pageResult;
    }

    @Override
    public PageResult of(List<T> result, Long total) {
        DefaultPageResult<T> pageResult = new DefaultPageResult<T>();
        pageResult.setTotalRow(total);
        pageResult.setList(result);
        pageResult.setPage(this.pageNumber);
        pageResult.setPageSize(this.pageSize);
        pageResult.calcTotalPage();
        return pageResult;
    }

    @Override
    public long getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public boolean isTotalRequired() {
        return this.totalRequired;
    }

    @Override
    public boolean isListRequired() {
        return this.listRequired;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setTotalRequired(boolean totalRequired) {
        this.totalRequired = totalRequired;
    }

    public void setListRequired(boolean listRequired) {
        this.listRequired = listRequired;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultPageRequest)) {
            return false;
        }
        DefaultPageRequest other = (DefaultPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        if (this.isTotalRequired() != other.isTotalRequired()) {
            return false;
        }
        return this.isListRequired() == other.isListRequired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pageNumber = this.getPageNumber();
        result = result * 59 + (int)($pageNumber >>> 32 ^ $pageNumber);
        result = result * 59 + this.getPageSize();
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        result = result * 59 + (this.isTotalRequired() ? 79 : 97);
        result = result * 59 + (this.isListRequired() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DefaultPageRequest(pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", orderBy=" + this.getOrderBy() + ", totalRequired=" + this.isTotalRequired() + ", listRequired=" + this.isListRequired() + ")";
    }
}

