/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class DB2SqlStyle
extends AbstractDBStyle {
    DB2Range db2Range = new DB2Range(this);

    @Override
    public int getIdType(Class c, String idProperty) {
        List ans = BeanKit.getAllAnnotation((Class)c, (String)idProperty);
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
            break;
        }
        return idType;
    }

    @Override
    public String getName() {
        return "db2";
    }

    @Override
    public int getDBType() {
        return 6;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.db2Range;
    }

    protected String appendSetColumnAbsolute(Class<?> c, TableDesc table, String colName, String fieldName) {
        int type = table.getColDesc(colName).getSqlType();
        return this.getKeyWordHandler().getCol(colName) + "=" + this.appendExpress(fieldName + ",jdbc='" + type + "'") + ",";
    }

    protected String appendInsertValue(Class<?> c, TableDesc table, String fieldName, String col) {
        int type = table.getColDesc(col).getSqlType();
        return this.appendExpress(fieldName + ",jdbc='" + type + "'") + ",";
    }

    @Override
    public String getSeqValue(String seqName) {
        return "NEXT VALUE FOR " + seqName + " ";
    }

    static class DB2Range
    implements RangeSql {
        DB2SqlStyle style;

        public DB2Range(DB2SqlStyle style) {
            this.style = style;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = (Long)objOffset;
            offset = PageParamKit.db2sqlOffset(this.style.offsetStartZero, offset);
            long pageEnd = PageParamKit.db2sqlPageEnd(offset, limit);
            int capacity = jdbcSql.length() + 180;
            StringBuilder builder = new StringBuilder(capacity);
            builder.append(" SELECT * FROM ").append("(");
            builder.append("\tSELECT inner_query_b.*, ROWNUMBER() OVER() beetl_rn  FROM   ");
            builder.append("\t(   ").append(jdbcSql).append("\t) AS inner_query_b  ");
            builder.append(" )AS inner_query_a WHERE inner_query_a.beetl_rn BETWEEN ");
            builder.append(offset).append(" and ").append(pageEnd);
            return builder.toString();
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            return " SELECT * FROM (\tSELECT inner_query_b.*, ROWNUMBER() OVER() beetl_rn  FROM   \t(   " + template + this.style.getOrderBy() + "\t) AS inner_query_b   )AS inner_query_a WHERE inner_query_a.beetl_rn BETWEEN " + this.style.appendExpress("_pageOffset") + " and " + this.style.appendExpress("_pageEnd");
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            long s = offset + (long)(this.style.offsetStartZero ? 1 : 0);
            paras.put("_pageOffset", s);
            paras.put("_pageEnd", s + size - 1L);
        }
    }
}

