/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.loader.SQLFileParser;

public class MarkdownParser
implements SQLFileParser {
    BufferedReader br;
    String namepspace;
    int linNumber;
    String lastLine;
    String penultimateLine;
    int status = 0;
    private static int END = 1;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");
    protected boolean inBody = false;

    public MarkdownParser(String namepspace, BufferedReader br) throws IOException {
        this.namepspace = namepspace;
        this.br = br;
        this.skipHeader();
    }

    protected void skipHeader() throws IOException {
        String line;
        do {
            line = this.nextLine();
            if (this.status != END) continue;
            return;
        } while (!line.startsWith("==="));
    }

    @Override
    public SQLSource next() throws IOException {
        String sqlId = this.readSqlId();
        if (this.status == END) {
            return null;
        }
        sqlId = sqlId.trim();
        this.skipComment();
        if (this.status == END) {
            return null;
        }
        int sqlLine = this.linNumber;
        if (this.lastLine.equals("```") || this.lastLine.equals("~~~")) {
            ++sqlLine;
        }
        String sql = this.readSql();
        SqlId newId = SqlId.of(this.namepspace, sqlId);
        SQLSource source = new SQLSource(newId, sql);
        source.setLine(sqlLine);
        this.inBody = false;
        return source;
    }

    protected void skipComment() throws IOException {
        String line;
        boolean findComment = false;
        do {
            line = this.nextLine();
            if (this.status != END) continue;
            return;
        } while ((line = line.trim()).length() == 0 || line.startsWith("*"));
        this.inBody = true;
    }

    protected String readSql() throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        list.add(this.lastLine);
        while (true) {
            String line = this.nextLine();
            if (this.status == END) {
                return this.getBuildSql(list);
            }
            if (line.startsWith("===")) {
                list.remove(list.size() - 1);
                return this.getBuildSql(list);
            }
            list.add(line);
        }
    }

    protected String getBuildSql(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            String s = str.trim();
            if (s.startsWith("```") || s.startsWith("~~~")) continue;
            sb.append(str).append(lineSeparator);
        }
        return sb.toString();
    }

    protected String readSqlId() {
        return this.penultimateLine;
    }

    protected String nextLine() throws IOException {
        String line = this.br.readLine();
        ++this.linNumber;
        if (line == null) {
            this.status = END;
        }
        this.penultimateLine = this.lastLine;
        this.lastLine = line;
        return line;
    }
}

