/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.range;

import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class OffsetLimitRange
implements RangeSql {
    AbstractDBStyle sqlStyle = null;

    public OffsetLimitRange(AbstractDBStyle style) {
        this.sqlStyle = style;
    }

    @Override
    public String toRange(String jdbcSql, Object objOffset, Long limit) {
        Long offset = ((Number)objOffset).longValue();
        offset = PageParamKit.mysqlOffset(this.sqlStyle.offsetStartZero, offset);
        StringBuilder builder = new StringBuilder(jdbcSql);
        builder.append(" limit ").append(offset).append(" , ").append(limit);
        return builder.toString();
    }

    @Override
    public String toTemplateRange(Class mapping, String template) {
        return template + this.sqlStyle.getOrderBy() + " \nlimit " + this.sqlStyle.appendExpress("_pageOffset") + " , " + this.sqlStyle.appendExpress("_pageSize");
    }

    @Override
    public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
        Long offset = (Long)objOffset;
        paras.put("_pageOffset", offset - (long)(this.sqlStyle.offsetStartZero ? 0 : 1));
        paras.put("_pageSize", size);
    }
}

