/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.annotation.builder;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.annotation.builder.FillStrategy;
import org.beetl.sql.annotation.builder.UpdateTime;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;

public class UpdateTimeConvert
implements AttributeConvert {
    @Override
    public Object toDb(ExecuteContext ctx, Class cls, String name, Object dbValue) {
        Comparable<ChronoLocalDateTime<?>> now;
        UpdateTime fillDateTime = (UpdateTime)BeanKit.getAnnotation((Class)cls, (String)name, UpdateTime.class);
        FillStrategy fillStrategy = fillDateTime.value();
        SQLType sqlType = ctx.sqlSource.getSqlType();
        if (FillStrategy.INSERT == fillStrategy && SQLType.INSERT != sqlType) {
            return null;
        }
        if (FillStrategy.UPDATE == fillStrategy && SQLType.UPDATE != sqlType) {
            return null;
        }
        if (FillStrategy.INSERT_UPDATE == fillStrategy && !sqlType.isUpdate()) {
            return null;
        }
        Class<?> dateType = BeanKit.getPropertyDescriptor((Class)cls, (String)name).getPropertyType();
        if (LocalDateTime.class == dateType) {
            now = LocalDateTime.now();
        } else if (LocalDate.class == dateType) {
            now = LocalDate.now();
        } else if (Timestamp.class == dateType) {
            now = new Timestamp(System.currentTimeMillis());
        } else if (java.sql.Date.class == dateType) {
            now = new java.sql.Date(System.currentTimeMillis());
        } else if (Date.class == dateType) {
            now = new Date();
        } else {
            throw new BeetlSQLException(23, "\u671f\u671b\u7c7b\u578b\u662f\u65e5\u671f\u7c7b\u578b\uff0c\u4f46\u662f " + cls);
        }
        BeanKit.setBeanProperty((Object)dbValue, (Object)now, (String)name);
        return now;
    }

    @Override
    public Object toAttr(ExecuteContext ctx, Class cls, String name, ResultSet rs, int index) throws SQLException {
        Comparable<ChronoLocalDateTime<?>> now;
        Class<?> dateType = BeanKit.getPropertyDescriptor((Class)cls, (String)name).getPropertyType();
        if (LocalDateTime.class == dateType) {
            now = rs.getTimestamp(index).toLocalDateTime();
        } else if (LocalDate.class == dateType) {
            now = rs.getTimestamp(index).toLocalDateTime().toLocalDate();
        } else if (Timestamp.class == dateType) {
            now = rs.getTimestamp(index);
        } else if (java.sql.Date.class == dateType) {
            now = rs.getDate(index);
        } else if (Date.class == dateType) {
            now = rs.getTimestamp(index);
        } else {
            throw new BeetlSQLException(23, "\u671f\u671b\u7c7b\u578b\u662f\u65e5\u671f\u7c7b\u578b\uff0c\u4f46\u662f " + cls);
        }
        return now;
    }
}

