/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.beetl.sql.annotation.entity.EnumValue;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.Cache;
import org.beetl.sql.clazz.kit.DefaultCache;

public class EnumKit {
    private static final Cache<Class, EnumConfig> cache = new DefaultCache();

    public static Enum getEnumByValue(Class c, Object value) {
        if (value == null) {
            return null;
        }
        if (!c.isEnum()) {
            throw new IllegalArgumentException(c.getName());
        }
        EnumConfig config = (EnumConfig)cache.get((Object)c);
        if (config == null) {
            config = EnumKit.init(c);
        }
        if (Short.class == value.getClass()) {
            value = ((Short)value).intValue();
        }
        return config.map.get(value);
    }

    public static Object getValueByEnum(Object en) {
        if (en == null) {
            return null;
        }
        Class<?> c = en.getClass();
        EnumConfig config = (EnumConfig)cache.get(c);
        if (config == null) {
            config = EnumKit.init(c);
        }
        return config.dbMap.get(en);
    }

    public static EnumConfig init(Class c) {
        EnumConfig config = (EnumConfig)cache.get((Object)c);
        if (config != null) {
            return config;
        }
        String valueAttrName = EnumKit.lookupEnumValueAttr(c);
        config = valueAttrName != null ? EnumKit.init(c, valueAttrName) : EnumKit.initDefaultValue(c);
        return config;
    }

    public static void init(Class c, EnumConfig config) {
        cache.putIfAbsent((Object)c, (Object)config);
    }

    private static EnumConfig initDefaultValue(Class c) {
        Enum[] temporaryConstants;
        HashMap<Object, Enum> map = new HashMap<Object, Enum>();
        HashMap<Enum, Object> map2 = new HashMap<Enum, Object>();
        for (Enum e : temporaryConstants = EnumKit.getEnumValues(c)) {
            String key = e.name();
            map.put(key, e);
            map2.put(e, key);
        }
        EnumConfig config = new EnumConfig(map, map2);
        cache.put((Object)c, (Object)config);
        return config;
    }

    public static EnumConfig init(Class entityClass, String attr) {
        EnumConfig enumConfig = (EnumConfig)cache.get((Object)entityClass);
        if (enumConfig != null) {
            return enumConfig;
        }
        try {
            PropertyDescriptor[] ps;
            for (PropertyDescriptor p : ps = BeanKit.propertyDescriptors((Class)entityClass)) {
                if (!p.getName().equals(attr)) continue;
                enumConfig = EnumKit.init(entityClass, p);
                return enumConfig;
            }
            throw new RuntimeException("\u5728" + entityClass.getCanonicalName() + "\u4e2d\u65e0\u6cd5\u627e\u5230\u5b57\u6bb5 " + attr);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String lookupEnumValueAttr(Class enumClass) {
        PropertyDescriptor[] ps = null;
        try {
            ps = BeanKit.propertyDescriptors((Class)enumClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        for (PropertyDescriptor p : ps) {
            String attr;
            EnumValue enumValue;
            Method readMethod = p.getReadMethod();
            if (readMethod.getDeclaringClass() == Object.class || (enumValue = (EnumValue)BeanKit.getAnnotation((Class)enumClass, (String)(attr = p.getName()), (Method)readMethod, EnumValue.class)) == null) continue;
            return attr;
        }
        return null;
    }

    private static EnumConfig init(Class entityClass, PropertyDescriptor p) {
        try {
            Enum[] temporaryConstants;
            Method m = p.getReadMethod();
            HashMap<Object, Enum> map = new HashMap<Object, Enum>();
            HashMap<Enum, Object> map2 = new HashMap<Enum, Object>();
            for (Enum e : temporaryConstants = EnumKit.getEnumValues(entityClass)) {
                Object key = m.invoke((Object)e, new Object[0]);
                map.put(key, e);
                map2.put(e, key);
            }
            EnumConfig config = new EnumConfig(map, map2);
            cache.put((Object)entityClass, (Object)config);
            return config;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Enum[] getEnumValues(Class c) {
        try {
            final Method values = c.getMethod("values", new Class[0]);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    values.setAccessible(true);
                    return null;
                }
            });
            Enum[] temporaryConstants = (Enum[])values.invoke(null, new Object[0]);
            return temporaryConstants;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Color c = Color.RED;
        Object value = EnumKit.getValueByEnum((Object)c);
        System.out.println(value);
        String a = "BLUE";
        Color e = (Color)EnumKit.getEnumByValue(Color.class, 1);
        System.out.println((Object)e);
    }

    public static enum Color {
        RED("RED", 1),
        BLUE("BLUE", 2);

        private String name;
        private int value;

        private Color(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class EnumConfig {
        Map<Object, Enum> map;
        Map<Enum, Object> dbMap;

        public EnumConfig(Map<Object, Enum> map, Map<Enum, Object> dbMap) {
            this.map = map;
            this.dbMap = dbMap;
        }
    }
}

