/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.annotation.entity.View;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLManagerExtend;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.mapping.type.BigDecimalTypeHandler;
import org.beetl.sql.core.mapping.type.BlobJavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.BooleanTypeHandler;
import org.beetl.sql.core.mapping.type.ByteArrayTypeHandler;
import org.beetl.sql.core.mapping.type.ByteTypeHandler;
import org.beetl.sql.core.mapping.type.CLobJavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.CharArrayTypeHandler;
import org.beetl.sql.core.mapping.type.DateTypeHandler;
import org.beetl.sql.core.mapping.type.DefaultTypeHandler;
import org.beetl.sql.core.mapping.type.DoubleTypeHandler;
import org.beetl.sql.core.mapping.type.FloatTypeHandler;
import org.beetl.sql.core.mapping.type.IntegerTypeHandler;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.LocalDateTimeTypeHandler;
import org.beetl.sql.core.mapping.type.LocalDateTypeHandler;
import org.beetl.sql.core.mapping.type.LongTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;
import org.beetl.sql.core.mapping.type.ShortTypeHandler;
import org.beetl.sql.core.mapping.type.SqlDateTypeHandler;
import org.beetl.sql.core.mapping.type.SqlXMLTypeHandler;
import org.beetl.sql.core.mapping.type.StringTypeHandler;
import org.beetl.sql.core.mapping.type.TemporalTypeHandler;
import org.beetl.sql.core.mapping.type.TimeTypeHandler;
import org.beetl.sql.core.mapping.type.TimestampTypeHandler;
import org.beetl.sql.core.mapping.type.UtilDateTypeHandler;
import org.beetl.sql.core.mapping.type.WriteTypeParameter;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    protected static final int PROPERTY_IGNORE = -2;
    static BigDecimalTypeHandler bigDecimalHandler = new BigDecimalTypeHandler();
    static BooleanTypeHandler booleanDecimalHandler = new BooleanTypeHandler();
    static ByteArrayTypeHandler byteArrayTypeHandler = new ByteArrayTypeHandler();
    static ByteTypeHandler byteTypeHandler = new ByteTypeHandler();
    static CharArrayTypeHandler charArrayTypeHandler = new CharArrayTypeHandler();
    static DateTypeHandler dateTypeHandler = new DateTypeHandler();
    static DoubleTypeHandler doubleTypeHandler = new DoubleTypeHandler();
    static FloatTypeHandler floatTypeHandler = new FloatTypeHandler();
    static IntegerTypeHandler integerTypeHandler = new IntegerTypeHandler();
    static LongTypeHandler longTypeHandler = new LongTypeHandler();
    static ShortTypeHandler shortTypeHandler = new ShortTypeHandler();
    static SqlDateTypeHandler sqlDateTypeHandler = new SqlDateTypeHandler();
    static UtilDateTypeHandler utilDateTypeHandler = new UtilDateTypeHandler();
    static SqlXMLTypeHandler sqlXMLTypeHandler = new SqlXMLTypeHandler();
    static StringTypeHandler stringTypeHandler = new StringTypeHandler();
    static TimestampTypeHandler timestampTypeHandler = new TimestampTypeHandler();
    static TimeTypeHandler timeTypeHandler = new TimeTypeHandler();
    static CLobJavaSqlTypeHandler clobTypeHandler = new CLobJavaSqlTypeHandler();
    static BlobJavaSqlTypeHandler blobTypeHandler = new BlobJavaSqlTypeHandler();
    static LocalDateTimeTypeHandler localDateTimeHandler = new LocalDateTimeTypeHandler();
    static LocalDateTypeHandler localDateHandler = new LocalDateTypeHandler();
    protected Map<Class, JavaSqlTypeHandler> handlers = new HashMap<Class, JavaSqlTypeHandler>();
    List<AcceptType> acceptTypeList = new ArrayList<AcceptType>();
    protected JavaSqlTypeHandler defaultHandler = new DefaultTypeHandler();

    public BeanProcessor() {
        this.initHandlers();
    }

    private void initHandlers() {
        this.handlers.put(BigDecimal.class, bigDecimalHandler);
        this.handlers.put(Boolean.class, booleanDecimalHandler);
        this.handlers.put(Boolean.TYPE, booleanDecimalHandler);
        this.handlers.put(byte[].class, byteArrayTypeHandler);
        this.handlers.put(Byte.TYPE, byteTypeHandler);
        this.handlers.put(Byte.class, byteTypeHandler);
        this.handlers.put(char[].class, charArrayTypeHandler);
        this.handlers.put(java.util.Date.class, dateTypeHandler);
        this.handlers.put(Double.class, doubleTypeHandler);
        this.handlers.put(Double.TYPE, doubleTypeHandler);
        this.handlers.put(Float.class, floatTypeHandler);
        this.handlers.put(Float.TYPE, floatTypeHandler);
        this.handlers.put(Integer.class, integerTypeHandler);
        this.handlers.put(Integer.TYPE, integerTypeHandler);
        this.handlers.put(Long.class, longTypeHandler);
        this.handlers.put(Long.TYPE, longTypeHandler);
        this.handlers.put(Short.class, shortTypeHandler);
        this.handlers.put(Short.TYPE, shortTypeHandler);
        this.handlers.put(Date.class, sqlDateTypeHandler);
        this.handlers.put(java.util.Date.class, utilDateTypeHandler);
        this.handlers.put(SQLXML.class, sqlXMLTypeHandler);
        this.handlers.put(String.class, stringTypeHandler);
        this.handlers.put(Timestamp.class, timestampTypeHandler);
        this.handlers.put(Time.class, timeTypeHandler);
        this.handlers.put(Clob.class, clobTypeHandler);
        this.handlers.put(Blob.class, blobTypeHandler);
        this.handlers.put(LocalDateTime.class, localDateTimeHandler);
        this.handlers.put(LocalDate.class, localDateHandler);
        this.acceptTypeList.add(new TemporalAcceptType(dateTypeHandler));
        this.acceptTypeList.add(new EnumAcceptType());
    }

    public <T> List<T> mappingSelect(ExecuteContext ctx, ResultSet rs, Class<T> clazz) throws SQLException {
        List<Object> resultList = null;
        if (Map.class.isAssignableFrom(clazz)) {
            resultList = new ArrayList();
            while (rs.next()) {
                Map<String, Object> map = this.toMap(ctx, clazz, rs);
                resultList.add(map);
            }
            return resultList;
        }
        if (BeanKit.isBaseDataType(clazz)) {
            resultList = new ArrayList(1);
            while (rs.next()) {
                Object result = this.toBaseType(ctx, clazz, rs);
                resultList.add(result);
            }
        } else {
            resultList = this.toBeanList(ctx, rs, clazz);
            return resultList;
        }
        return resultList;
    }

    public <T> T toBean(ExecuteContext ctx, ResultSet rs, Class<T> type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(ctx, type, rsmd, props);
        return this.createBean(ctx, rs, type, props, columnToProperty);
    }

    public <T> List<T> toBeanList(ExecuteContext ctx, ResultSet rs, Class<T> type) throws SQLException {
        if (!rs.next()) {
            return new ArrayList(0);
        }
        List results = this.newList();
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(ctx, type, rsmd, props);
        do {
            results.add(this.createBean(ctx, rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    protected List newList() {
        return new ArrayList();
    }

    public Map<String, Object> toMap(ExecuteContext ctx, Class<?> c, ResultSet rs) throws SQLException {
        Map result = BeanKit.getMapIns(c);
        if (c == null) {
            throw new SQLException("\u4e0d\u80fd\u6620\u5c04\u6210Map:" + c);
        }
        SqlId sqlId = ctx.sqlId;
        NameConversion nc = ctx.sqlManager.getNc();
        DBStyle dbStyle = ctx.sqlManager.getDbStyle();
        String dbName = dbStyle.getName();
        int dbType = dbStyle.getDBType();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        ReadTypeParameter tp = new ReadTypeParameter(sqlId, dbName, null, rs, rsmd, 0, ctx);
        for (int i = 1; i <= cols; ++i) {
            String columnName = this.getColName(ctx, rsmd, i);
            int colType = rsmd.getColumnType(i);
            if ((dbType == 2 || dbType == 4) && columnName.equalsIgnoreCase("beetl_rn")) continue;
            Class classType = (Class)JavaType.jdbcJavaTypes.get(colType);
            JavaSqlTypeHandler handler = this.getHandler(classType);
            if (handler == null) {
                handler = this.defaultHandler;
            }
            tp.setIndex(i);
            tp.setTarget(classType);
            Object value = handler.getValue(tp);
            result.put(nc.getPropertyName(c, columnName), value);
        }
        return result;
    }

    public Object toBaseType(ExecuteContext ctx, Class<?> c, ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        SqlId sqlId = ctx.sqlId;
        NameConversion nc = ctx.sqlManager.getNc();
        DBStyle dbStyle = ctx.sqlManager.getDbStyle();
        String dbName = dbStyle.getName();
        int dbType = dbStyle.getDBType();
        int count = meta.getColumnCount();
        int index = 0;
        if (count == 1) {
            index = 1;
        } else if (count == 2 && (dbType == 2 || dbType == 4)) {
            String name1 = meta.getColumnName(1);
            String name2 = meta.getColumnName(2);
            int n = index = name2.equalsIgnoreCase("beetl_rn") ? 1 : 2;
        }
        if (index == 0) {
            throw new SQLException("Beetlsql\u67e5\u8be2\u671f\u671b\u8fd4\u56de\u4e00\u5217\uff0c\u8fd4\u56de\u7c7b\u578b\u4e3a" + c + " \u4f46\u8fd4\u56de\u4e86" + count + "\u5217\uff0c" + sqlId);
        }
        ReadTypeParameter tp = new ReadTypeParameter(sqlId, dbName, c, rs, meta, index, ctx);
        JavaSqlTypeHandler handler = this.getHandler(c);
        if (handler == null) {
            handler = this.defaultHandler;
        }
        return handler.getValue(tp);
    }

    protected <T> T createBean(ExecuteContext ctx, ResultSet rs, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        T bean = this.newInstance(type);
        ResultSetMetaData meta = rs.getMetaData();
        Class<?> viewType = ctx.viewClass;
        SqlId sqlId = ctx.sqlId;
        NameConversion nc = ctx.sqlManager.getNc();
        DBStyle dbStyle = ctx.sqlManager.getDbStyle();
        String dbName = dbStyle.getName();
        int dbType = dbStyle.getDBType();
        ReadTypeParameter tp = new ReadTypeParameter(sqlId, dbName, type, rs, meta, 1, ctx);
        ClassAnnotation ca = ClassAnnotation.getClassAnnotation(type);
        Map<String, AttributeConvert> attrMap = null;
        AttributeConvert convert = null;
        if (ca.isContainExtAnnotation()) {
            attrMap = ca.getExtAnnotation().getAttributeConvertMap();
        }
        for (int i = 1; i < columnToProperty.length; ++i) {
            Object value;
            if (columnToProperty[i] == -2) continue;
            tp.setIndex(i);
            if (columnToProperty[i] == -1) {
                String key = this.getColName(ctx, meta, i);
                if ((dbType == 2 || dbType == 4) && key.equalsIgnoreCase("beetl_rn") || !(bean instanceof Tail)) continue;
                Tail bean2 = (Tail)bean;
                value = this.noMappingValue(tp);
                key = nc.getPropertyName(type, key);
                bean2.set(key, value);
                continue;
            }
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            value = null;
            if (attrMap != null) {
                convert = attrMap.get(prop.getName());
            }
            if (convert != null) {
                value = convert.toAttr(ctx, type, prop.getName(), rs, i);
            } else {
                tp.setTarget(propType);
                JavaSqlTypeHandler handler = this.getHandler(propType);
                if (handler == null) {
                    handler = this.defaultHandler;
                }
                value = handler.getValue(tp);
            }
            this.callSetter(bean, prop, value, propType);
        }
        return bean;
    }

    protected Object noMappingValue(ReadTypeParameter tp) throws SQLException {
        JavaSqlTypeHandler handler;
        Object value = null;
        Class expectedType = (Class)JavaType.jdbcJavaTypes.get(tp.getColumnType());
        value = expectedType != null ? ((handler = this.getHandler(expectedType)) == null ? tp.getObject() : handler.getValue(tp)) : tp.getObject();
        return value;
    }

    public void callSetter(Object target, PropertyDescriptor prop, Object value, Class<?> type) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        try {
            setter.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    protected <T> T newInstance(Class<T> c) throws SQLException {
        return (T)BeanKit.newInstance(c);
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        try {
            return BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected int[] mapColumnsToProperties(ExecuteContext ctx, Class<?> c, ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        NameConversion nc = ctx.sqlManager.getNc();
        Class<?> viewType = ctx.viewClass;
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        HashMap<String, ColMapping> property2Column = new HashMap<String, ColMapping>(columnToProperty.length);
        for (int col = 1; col <= cols; ++col) {
            String columnName = this.getColName(ctx, rsmd, col);
            String expectedProperty = nc.getPropertyName(c, columnName);
            property2Column.put(expectedProperty, new ColMapping(columnName, col));
        }
        for (int i = 0; i < props.length; ++i) {
            ColMapping colMapping = (ColMapping)property2Column.get(props[i].getName());
            if (colMapping == null) continue;
            int col = colMapping.index;
            if (viewType == null) {
                columnToProperty[col] = i;
                continue;
            }
            View viewAnnotation = (View)BeanKit.getAnnotation(c, (String)props[i].getName(), (Method)props[i].getReadMethod(), View.class);
            if (viewAnnotation == null || !BeanKit.containViewType((Class[])viewAnnotation.value(), viewType)) continue;
            columnToProperty[col] = -2;
        }
        return columnToProperty;
    }

    protected String getColName(ExecuteContext ctx, ResultSetMetaData rsmd, int col) throws SQLException {
        String columnName = rsmd.getColumnLabel(col);
        if (null == columnName || 0 == columnName.length()) {
            columnName = rsmd.getColumnName(col);
        }
        return columnName;
    }

    public void setPreparedStatementPara(ExecuteContext ctx, PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        int i;
        SqlId sqlId = ctx.sqlId;
        NameConversion nc = ctx.sqlManager.getNc();
        DBStyle dbStyle = ctx.sqlManager.getDbStyle();
        String dbName = dbStyle.getName();
        int dbType = dbStyle.getDBType();
        SQLParameter para = null;
        WriteTypeParameter writeTypeParameter = new WriteTypeParameter(ctx.sqlId, dbName, dbType, ctx.target, ps, 0, ctx);
        try {
            for (i = 0; i < objs.size(); ++i) {
                para = objs.get(i);
                Object o = para.value;
                int jdbcType = para.getJdbcType();
                if (o == null) {
                    if (jdbcType != 0) {
                        ps.setNull(i + 1, jdbcType);
                        continue;
                    }
                    ps.setObject(i + 1, o);
                    continue;
                }
                writeTypeParameter.setIndex(i + 1);
                Class<?> c = o.getClass();
                JavaSqlTypeHandler handler = this.getHandler(c);
                if (handler == null) {
                    handler = this.defaultHandler;
                }
                if (jdbcType != 0) {
                    ps.setObject(i + 1, o, jdbcType);
                    continue;
                }
                handler.setParameter(writeTypeParameter, o);
            }
        }
        catch (SQLException ex) {
            throw new SQLException("\u5904\u7406\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570\u9519\u8bef:" + ex.getMessage(), ex);
        }
    }

    public JavaSqlTypeHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(JavaSqlTypeHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public Map<Class, JavaSqlTypeHandler> getHandlers() {
        return this.handlers;
    }

    public void addHandler(Class target, JavaSqlTypeHandler handler) {
        this.handlers.put(target, handler);
    }

    public void addAcceptType(AcceptType acceptType) {
        this.acceptTypeList.add(0, acceptType);
    }

    public JavaSqlTypeHandler getHandler(Class target) {
        JavaSqlTypeHandler handler;
        block2: {
            AcceptType acceptType;
            if (target == null) {
                return this.defaultHandler;
            }
            handler = this.handlers.get(target);
            if (handler != null || this.acceptTypeList.isEmpty()) break block2;
            Iterator<AcceptType> iterator = this.acceptTypeList.iterator();
            while (iterator.hasNext() && (handler = (acceptType = iterator.next()).isAccept(target)) == null) {
            }
        }
        return handler;
    }

    public static class InheritedAcceptType
    implements AcceptType {
        Class parent;
        JavaSqlTypeHandler handler;

        public InheritedAcceptType(Class parent, JavaSqlTypeHandler handler) {
            this.parent = parent;
            this.handler = handler;
        }

        @Override
        public JavaSqlTypeHandler isAccept(Class cls) {
            if (this.parent.isAssignableFrom(cls)) {
                return this.handler;
            }
            return null;
        }
    }

    public static class EnumTypeHandler
    extends JavaSqlTypeHandler {
        @Override
        public Object getValue(ReadTypeParameter typePara) throws SQLException {
            Object obj = typePara.getObject();
            if (obj == null) {
                return null;
            }
            if (typePara.target == null) {
                return obj;
            }
            Enum enumValue = this.obj2enum(typePara, obj);
            if (enumValue == null) {
                throw new SQLException("Cannot set ENUM " + typePara.target + ": Convert to NULL for value " + obj);
            }
            return enumValue;
        }

        @Override
        public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
            Object value = this.enum2Obj(writeTypeParameter, obj);
            if (value == null) {
                writeTypeParameter.getPs().setObject(writeTypeParameter.getIndex(), null);
            }
            Class<?> target = value.getClass();
            JavaSqlTypeHandler handler = writeTypeParameter.getExecuteContext().sqlManager.getDefaultBeanProcessors().getHandler(target);
            handler.setParameter(writeTypeParameter, value);
        }

        protected Enum obj2enum(ReadTypeParameter typePara, Object obj) {
            SQLManagerExtend sqlManagerExtend = typePara.getExecuteContext().sqlManager.getSqlManagerExtend();
            Enum enumValue = sqlManagerExtend.getEnumExtend().getEnumByValue(typePara.target, obj);
            return enumValue;
        }

        protected Object enum2Obj(WriteTypeParameter writeTypeParameter, Object obj) {
            SQLManagerExtend sqlManagerExtend = writeTypeParameter.getExecuteContext().sqlManager.getSqlManagerExtend();
            Object value = sqlManagerExtend.getEnumExtend().getValueByEnum(obj);
            return value;
        }
    }

    public static class TemporalAcceptType
    implements AcceptType {
        TemporalTypeHandler temporalHandler;
        DateTypeHandler dateTypeHandler;

        public TemporalAcceptType(DateTypeHandler dateTypeHandler) {
            this.dateTypeHandler = dateTypeHandler;
            this.temporalHandler = new TemporalTypeHandler();
        }

        @Override
        public JavaSqlTypeHandler isAccept(Class cls) {
            if (Temporal.class.isAssignableFrom(cls)) {
                return this.temporalHandler;
            }
            if (java.util.Date.class.isAssignableFrom(cls)) {
                return this.dateTypeHandler;
            }
            return null;
        }
    }

    public static class EnumAcceptType
    implements AcceptType {
        EnumTypeHandler enumTypeHandler = new EnumTypeHandler();

        @Override
        public JavaSqlTypeHandler isAccept(Class cls) {
            if (Enum.class.isAssignableFrom(cls)) {
                return this.enumTypeHandler;
            }
            return null;
        }
    }

    public static interface AcceptType {
        public JavaSqlTypeHandler isAccept(Class var1);
    }

    protected static class ColMapping {
        String col;
        int index;

        public ColMapping(String col, int index) {
            this.col = col;
            this.index = index;
        }
    }
}

