/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.type;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;
import org.beetl.sql.core.mapping.type.WriteTypeParameter;

public class LocalDateTypeHandler
extends JavaSqlTypeHandler {
    @Override
    public Object getValue(ReadTypeParameter typePara) throws SQLException {
        Timestamp ts = typePara.getRs().getTimestamp(typePara.getIndex());
        return ts == null ? null : ts.toLocalDateTime().toLocalDate();
    }

    @Override
    public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
        LocalDate localDate = (LocalDate)obj;
        long ts = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Timestamp time = new Timestamp(ts);
        writeTypeParameter.getPs().setTimestamp(writeTypeParameter.getIndex(), time);
    }

    @Override
    public int jdbcType() {
        return 91;
    }
}

