/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beetl.sql.clazz.EnumKit;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.core.query.interfacer.QueryExecuteI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JLogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(Slf4JLogInterceptor.class);
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    protected static String mapperName = "org.beetl.sql.mapper.MapperJavaProxy";
    protected static String sqlManager = SQLManager.class.getName();
    protected static String queryClassName = Query.class.getName();
    protected static String lambdaQueryName = LambdaQuery.class.getName();
    protected static String defaultQueryMethod = QueryExecuteI.class.getName();
    protected boolean showLineNum;
    protected String preferredShowClass;

    public Slf4JLogInterceptor() {
    }

    public Slf4JLogInterceptor(boolean showLineNum, String preferredShowClass) {
        this.showLineNum = showLineNum;
        this.preferredShowClass = preferredShowClass;
    }

    public static String formatSql(String sql) {
        return sql.replaceAll("--.*", "").replaceAll(" ?\r?\n", " ");
    }

    @Override
    public void before(InterceptorContext ctx) {
        if (!log.isDebugEnabled()) {
            return;
        }
        ExecuteContext executeContext = ctx.getExecuteContext();
        String sqlId = executeContext.sqlId.toString();
        String jdbcSql = ctx.getExecuteContext().sqlResult.jdbcSql;
        ctx.put("debug.time", System.currentTimeMillis());
        StringBuilder sb = new StringBuilder(this.formatSqlId(sqlId)).append(LINE_SEPARATOR);
        sb.append("\u250c SQL:\t").append(Slf4JLogInterceptor.formatSql(jdbcSql)).append(LINE_SEPARATOR).append("\u251c \u53c2\u6570:\t").append(this.formatParas(ctx.getExecuteContext().sqlResult.jdbcPara)).append(LINE_SEPARATOR);
        if (this.showLineNum) {
            RuntimeException ex = new RuntimeException();
            StackTraceElement[] traces = ex.getStackTrace();
            int index = this.lookBusinessCodeInTrace(traces);
            StackTraceElement businessCode = traces[index];
            String className = businessCode.getClassName();
            String methodName = businessCode.getMethodName();
            int line = businessCode.getLineNumber();
            sb.append("\u251c \u4f4d\u7f6e:\t").append(className).append('.').append(methodName).append('(').append(businessCode.getFileName()).append(':').append(line).append(')').append(LINE_SEPARATOR);
        }
        ctx.put("logs", sb);
    }

    @Override
    public void after(InterceptorContext ctx) {
        if (!log.isDebugEnabled()) {
            return;
        }
        long start = (Long)ctx.get("debug.time");
        StringBuilder sb = (StringBuilder)ctx.get("logs");
        sb.append("\u251c \u65f6\u95f4:\t").append(System.currentTimeMillis() - start).append("ms").append(LINE_SEPARATOR);
        SQLType sqlType = ctx.getExecuteContext().sqlSource.sqlType;
        Object result = ctx.getExecuteContext().executeResult;
        if (sqlType.isUpdate()) {
            sb.append("\u2514 \u66f4\u65b0:\t[");
            if (result.getClass().isArray()) {
                int[] ret = (int[])result;
                for (int i = 0; i < ret.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(ret[i]);
                }
            } else {
                sb.append(result);
            }
            sb.append(']').append(LINE_SEPARATOR);
        } else if (result instanceof Collection) {
            sb.append("\u2514 \u7ed3\u679c:\t[").append(((Collection)result).size()).append(']');
        } else {
            sb.append("\u2514 \u7ed3\u679c:\t[").append(result).append(']');
        }
        this.print(sb.toString());
    }

    @Override
    public void exception(InterceptorContext ctx, Exception ex) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = (StringBuilder)ctx.get("logs");
            sb.append("\u2514 \u5f02\u5e38:\t").append(ex.getMessage());
            this.error(sb.toString());
        }
    }

    protected String formatSqlId(String id) {
        String sql = Slf4JLogInterceptor.formatSql(id);
        return sql.length() > 50 ? sql.substring(0, 50) + "..." : sql;
    }

    protected int lookBusinessCodeInTrace(StackTraceElement[] traces) {
        for (int i = traces.length - 1; i >= 0; --i) {
            String name = traces[i].getClassName();
            if (this.preferredShowClass != null && this.preferredShowClass.equals(name)) {
                return i;
            }
            if (name.equals(mapperName)) {
                int skipLine = JavaType.isJdk8() ? 3 : 2;
                return i + skipLine;
            }
            if (name.equals(lambdaQueryName)) {
                return i + 1;
            }
            if (name.equals(queryClassName)) {
                return i + 1;
            }
            if (name.equals(defaultQueryMethod)) {
                return i + 1;
            }
            if (!name.equals(sqlManager)) continue;
            return i + 1;
        }
        throw new IllegalStateException();
    }

    protected List<String> formatParas(List<SQLParameter> list) {
        ArrayList<String> data = new ArrayList<String>(list.size());
        for (SQLParameter para : list) {
            Object obj = para.value;
            if (obj == null) {
                data.add(null);
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 60) {
                    data.add(str.substring(0, 60) + "...(" + str.length() + ")");
                    continue;
                }
                data.add(str);
                continue;
            }
            if (obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd (HH:mm:ss.SSS)");
                data.add(sdf.format((Date)obj));
                continue;
            }
            if (obj instanceof Enum) {
                Object value = EnumKit.getValueByEnum(obj);
                data.add(String.valueOf(value));
                continue;
            }
            data.add(obj.toString());
        }
        return data;
    }

    protected void print(String str) {
        log.debug(str);
    }

    protected void error(String str) {
        log.error(str);
    }
}

