/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.join;

import java.lang.annotation.Annotation;
import java.sql.ResultSetMetaData;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Script;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.annotation.entity.JsonMapper;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.engine.template.BeetlTemplateEngine;
import org.beetl.sql.core.mapping.join.AttrNode;
import org.beetl.sql.core.mapping.join.ConfigJoinMapper;

public class JsonConfigMapper
extends ConfigJoinMapper {
    protected static Map<Key, AttrNode> cache = new ConcurrentHashMap<Key, AttrNode>();
    protected static Map<SqlIdKey, AttrNode> sqlIdCache = new ConcurrentHashMap<SqlIdKey, AttrNode>();
    static StringTemplateResourceLoader loader = new StringTemplateResourceLoader();

    @Override
    protected AttrNode parse(ExecuteContext ctx, Class target, ResultSetMetaData rsmd, Annotation config) throws Exception {
        AttrNode root;
        if (config == null) {
            Map mapping = (Map)ctx.getContextPara("jsonMapping");
            if (mapping == null) {
                throw new IllegalArgumentException("\u9700\u8981\u63d0\u4f9b\u6620\u5c04\u914d\u7f6e,@JsonMappingConfig\u6216\u8005\u5728sql\u6587\u4ef6\u91cc\u63d0\u4f9b'jsonMapping'\u53d8\u91cf\u4f5c\u4e3a\u914d\u7f6e ");
            }
            SqlIdKey key = new SqlIdKey(target, mapping);
            root = sqlIdCache.get(key);
            if (root == null) {
                Map<String, Integer> columnIndex = super.getColumnIndex(rsmd);
                root = new AttrNode(null);
                root.initNode(target, mapping, columnIndex);
                sqlIdCache.put(key, root);
            }
        } else {
            String jsonStr = this.getJsonRuleStr(ctx, target, config);
            Key key = new Key(target, jsonStr);
            root = cache.get(key);
            if (root == null) {
                Map<String, Integer> columnIndex = super.getColumnIndex(rsmd);
                Map<String, Object> mapping = this.getMappingByJson(ctx, jsonStr);
                root = new AttrNode(null);
                root.initNode(target, mapping, columnIndex);
                cache.put(key, root);
            }
        }
        return root;
    }

    protected String getJsonRuleStr(ExecuteContext ctx, Class target, Annotation config) {
        JsonMapper jsonMapper = (JsonMapper)config;
        String str = jsonMapper.value();
        String resource = jsonMapper.resource();
        if (str.length() != 0) {
            return str;
        }
        if (resource.length() != 0) {
            SQLSource sqlSource = ctx.sqlManager.getSqlLoader().querySQL(SqlId.of(resource));
            if (sqlSource == null) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u6620\u5c04\u914d\u7f6e " + resource);
            }
            return sqlSource.template;
        }
        throw new IllegalArgumentException("\u672a\u63d0\u4f9b\u6620\u5c04\u914d\u7f6e");
    }

    protected Map<String, Object> getMappingByJson(ExecuteContext ctx, String json) {
        BeetlTemplateEngine beetlTemplateEngine = (BeetlTemplateEngine)ctx.sqlManager.getSqlTemplateEngine();
        GroupTemplate gt = beetlTemplateEngine.getBeetl().getGroupTemplate();
        String scriptStr = "return (" + json + ");";
        try {
            Script script = gt.getScript((Object)scriptStr, (ResourceLoader)loader);
            script.execute();
            Map mapping = (Map)script.getReturnValue();
            return mapping;
        }
        catch (BeetlException beetlException) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684mapping\u914d\u7f6e " + beetlException.getMessage());
        }
    }

    protected Map<String, Object> getConfig(ExecuteContext ctx, Annotation config) {
        Map mapping = null;
        if (config == null) {
            mapping = (Map)ctx.getContextPara("jsonMapping");
            if (mapping == null) {
                throw new IllegalArgumentException("\u9700\u8981\u63d0\u4f9b\u6620\u5c04\u914d\u7f6e,@JsonMappingConfig\u6216\u8005\u5728sql\u6587\u4ef6\u91cc\u63d0\u4f9b'jsonMapping'\u53d8\u91cf\u4f5c\u4e3a\u914d\u7f6e ");
            }
            return mapping;
        }
        if (!(config instanceof JsonMapper)) {
            throw new IllegalArgumentException("\u914d\u7f6e\u671f\u671b\u662f JsonMappingConfig");
        }
        JsonMapper jsonMapper = (JsonMapper)config;
        String str = jsonMapper.value();
        String resource = jsonMapper.resource();
        if (str.length() != 0) {
            BeetlTemplateEngine beetlTemplateEngine = (BeetlTemplateEngine)ctx.sqlManager.getSqlTemplateEngine();
            GroupTemplate gt = beetlTemplateEngine.getBeetl().getGroupTemplate();
            String scriptStr = "return " + str + ";";
            try {
                Script script = gt.getScript((Object)scriptStr, (ResourceLoader)loader);
                script.execute();
                mapping = (Map)script.getReturnValue();
                return mapping;
            }
            catch (BeetlException beetlException) {
                throw new IllegalArgumentException("\u9519\u8bef\u7684mapping\u914d\u7f6e " + beetlException.getMessage());
            }
        }
        if (resource.length() != 0) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalArgumentException("\u672a\u63d0\u4f9b\u914d\u7f6e");
    }

    static class Key {
        Class target;
        String json;
        transient int hashCode = 0;

        public Key(Class target, String json) {
            this.target = target;
            this.json = json;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.target.equals(key.target) && this.json.equals(key.json);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Objects.hash(this.target, this.json);
            }
            return this.hashCode;
        }
    }

    static class SqlIdKey {
        Class target;
        Map mapping;
        transient int hashCode;

        public SqlIdKey(Class target, Map mapping) {
            this.target = target;
            this.mapping = mapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SqlIdKey sqlIdKey = (SqlIdKey)o;
            return this.target.equals(sqlIdKey.target) && this.mapping.equals(sqlIdKey.mapping);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Objects.hash(this.target, this.mapping);
            }
            return this.hashCode;
        }
    }
}

