/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.OracleStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class Oracle12Style
extends OracleStyle {
    Oracle12OffsetRange offsetRange = new Oracle12OffsetRange(this);

    @Override
    public RangeSql getRangeSql() {
        return this.offsetRange;
    }

    public static class Oracle12OffsetRange
    implements RangeSql {
        AbstractDBStyle dbStyle = null;

        public Oracle12OffsetRange(AbstractDBStyle dbStyle) {
            this.dbStyle = dbStyle;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            offset = PageParamKit.oracleOffset12(this.dbStyle.offsetStartZero, offset);
            StringBuilder builder = new StringBuilder(jdbcSql);
            builder.append(" OFFSET ");
            builder.append(offset);
            builder.append(" ROWS");
            builder.append(" FETCH NEXT ");
            builder.append(limit);
            builder.append(" ROWS ONLY ");
            return builder.toString();
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            String pageSql = template + " OFFSET " + this.dbStyle.appendExpress("_pageOffset") + " ROWS  FETCH NEXT " + this.dbStyle.appendExpress("_pageEnd") + " ROWS ONLY ";
            return pageSql;
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            long s = PageParamKit.oracleOffset12(this.dbStyle.offsetStartZero, (Long)objOffset);
            paras.put("_pageOffset", s);
            paras.put("_pageEnd", size);
        }
    }
}

