/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.MockClassDesc;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.CaseInsensitiveOrderSet;

public class TableDesc {
    private String name;
    private final Set<String> idNames = new CaseInsensitiveOrderSet();
    private String remark = null;
    private final Set<String> cols = new CaseInsensitiveOrderSet();
    private final Map<Class, ClassDesc> classes = new ConcurrentHashMap<Class, ClassDesc>();
    private final CaseInsensitiveHashMap<String, ColDesc> colsDetail = new CaseInsensitiveHashMap();
    private String schema;
    private String catalog;
    private String realTableName;

    public TableDesc(String name, String remark) {
        this.name = name;
        this.remark = remark;
    }

    public boolean containCol(String col) {
        return this.cols.contains(col);
    }

    public void addCols(ColDesc col) {
        this.colsDetail.put(col.getColName(), (Object)col);
        this.cols.add(col.getColName());
    }

    public ColDesc getColDesc(String name) {
        return (ColDesc)this.colsDetail.get((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getIdNames() {
        return this.idNames;
    }

    public void addIdName(String idName) {
        this.idNames.add(idName);
    }

    public Set<String> getCols() {
        return this.cols;
    }

    public String getRemark() {
        return this.remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassDesc genClassDesc(Class c, NameConversion nc) {
        ClassDesc classDesc = this.classes.get(c);
        if (classDesc != null) return classDesc;
        Class<ClassDesc> clazz = ClassDesc.class;
        synchronized (ClassDesc.class) {
            classDesc = this.classes.get(c);
            if (classDesc != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return classDesc;
            }
            classDesc = new ClassDesc(c, this, nc);
            this.classes.put(c, classDesc);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return classDesc;
        }
    }

    public MockClassDesc genClassDesc(NameConversion nc) {
        MockClassDesc c = new MockClassDesc(this, nc);
        return c;
    }

    public CaseInsensitiveHashMap<String, ColDesc> getColsDetail() {
        return this.colsDetail;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getRealTableName() {
        return this.realTableName;
    }

    public void setRealTableName(String realTableName) {
        this.realTableName = realTableName;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

