/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.annotation.builder.BeanConvert;
import org.beetl.sql.annotation.builder.TargetAdditional;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.ClassExtAnnotation;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.ArrayKit;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.ListUtil;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.SQLBatchReady;
import org.beetl.sql.core.SQLExecutor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.SqlIdWithParam;
import org.beetl.sql.core.call.CallArg;
import org.beetl.sql.core.call.CallReady;
import org.beetl.sql.core.call.InArg;
import org.beetl.sql.core.call.OutArg;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.engine.template.SQLTemplate;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.engine.template.TemplateContext;
import org.beetl.sql.core.mapping.BeanFetch;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.ResultSetMapper;
import org.beetl.sql.core.mapping.RowMapper;
import org.beetl.sql.core.mapping.RowMapperResultSetExt;
import org.beetl.sql.core.mapping.StreamData;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.meta.MetadataManager;

public class BaseSQLExecutor
implements SQLExecutor {
    ExecuteContext executeContext;

    public BaseSQLExecutor(ExecuteContext executeContext) {
        this.executeContext = executeContext;
    }

    protected static boolean isBaseDataType(Class<?> clazz) {
        return BeanKit.isBaseDataType(clazz);
    }

    @Override
    public int insert(Class clazz, Object paras) {
        KeyHolder holder = paras instanceof Map ? KeyHolder.empty : KeyHolder.getKeyHolderByClass(paras);
        int ret = this.insert(paras, holder);
        this.assignKeyHolder(holder, paras);
        return ret;
    }

    @Override
    public List<Object[]> insert(Class target, Object paras, String[] cols) {
        InterceptorContext ctx;
        ResultUpdateHolder ruh;
        Connection conn;
        block7: {
            conn = null;
            ruh = null;
            ctx = null;
            this.addParaIfAssignId(paras);
            Map map = this.beforeExecute(target, paras, true);
            SQLResult result = this.run(map);
            ctx = this.callInterceptorAsBefore(map);
            String sql = this.executeContext.sqlResult.jdbcSql;
            List<SQLParameter> jdbcPara = this.executeContext.sqlResult.jdbcPara;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            ruh = this.dbUpdateWithHolder(conn, sql, jdbcPara, cols);
            if (this.executeContext.sqlManager.getDbStyle().generatedKeysSupport()) break block7;
            ArrayList<Object[]> keyHolders = new ArrayList<Object[]>((Integer)ruh.getResultSet());
            this.callInterceptorAsAfter(ctx, ruh.resultSet);
            ArrayList<Object[]> arrayList = keyHolders;
            this.clean(true, conn, ruh);
            return arrayList;
        }
        try {
            ResultSet rs = ruh.statement.getGeneratedKeys();
            NameConversion nc = this.executeContext.sqlManager.getNc();
            ArrayList<Object[]> keyHolders = new ArrayList<Object[]>((Integer)ruh.getResultSet());
            while (rs.next()) {
                Object[] values = new Object[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    values[i] = rs.getObject(i + 1);
                }
                keyHolders.add(values);
            }
            rs.close();
            this.callInterceptorAsAfter(ctx, ruh.resultSet);
            ArrayList<Object[]> arrayList = keyHolders;
            this.clean(true, conn, ruh);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
    }

    @Override
    public <T> T singleSelect(Class<T> target, Object paras) {
        Map map = this.beforeExecute(target, paras, false);
        return this.selectSingle(map, target);
    }

    @Override
    public <T> T selectUnique(Class<T> target, Object paras) {
        Map map = this.beforeExecute(target, paras, false);
        List<T> result = this.select(target, map);
        int size = result.size();
        if (size == 1) {
            return result.get(0);
        }
        if (size == 0) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u53c2\u6570\u662f" + map);
        }
        throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u627e\u5230\u591a\u6761\u8bb0\u5f55:\u53c2\u6570\u662f" + map);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, Object paras) {
        Map map = this.beforeExecute(clazz, paras, false);
        return this.select(clazz, map);
    }

    protected <T> T selectSingle(Map<String, Object> map, Class<T> target) {
        List<T> result = this.select(target, map);
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    protected <T> List<T> select(Class<T> clazz, Map<String, Object> paras) {
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> jdbcPara = result.jdbcPara;
        ResultSetHolder rsh = null;
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        if (this.executeContext.executeResult != null) {
            this.callInterceptorAsAfter(ctx, this.executeContext.executeResult);
            return (List)this.executeContext.executeResult;
        }
        sql = this.executeContext.sqlResult.jdbcSql;
        jdbcPara = this.executeContext.sqlResult.jdbcPara;
        Connection conn = null;
        try {
            Object classAnnotation;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sql, jdbcPara);
            if (this.executeContext.customizedBeanProcessor != null) {
                resultList = this.executeContext.customizedBeanProcessor.toBeanList(this.executeContext, rsh.resultSet, clazz);
            } else {
                ResultSetMapper<?> resultSetMapper;
                classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
                RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : ((ClassAnnotation)classAnnotation).getRowMapper();
                ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : ((ClassAnnotation)classAnnotation).getResultSetMapper();
                if (resultSetMapper != null) {
                    resultList = resultSetMapper.mapping(this.executeContext, clazz, rsh.resultSet, ((ClassAnnotation)classAnnotation).getMapperConfig());
                } else if (rowMapper != null) {
                    BeanProcessor beanProcessor = this.getBeanProcessor();
                    resultList = new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, rsh.resultSet, (Class)clazz, ((ClassAnnotation)classAnnotation).getMapperConfig());
                } else {
                    resultList = this.mappingSelect(clazz, rsh.resultSet);
                }
            }
            this.executeContext.executeResult = resultList;
            this.callInterceptorAsAfter(ctx, resultList);
            classAnnotation = resultList = (List<T>)this.afterBean(resultList);
            this.clean(false, conn, rsh);
            return classAnnotation;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> mappingSelect(Class<T> target, ResultSet rs) throws SQLException {
        BeanProcessor beanProcessor = this.getBeanProcessor();
        return beanProcessor.mappingSelect(this.executeContext, rs, target);
    }

    @Override
    public <T> List<T> select(Class<T> target, Object paras, Object start, long size) {
        SQLExecutor newSqlEx = this.executeContext.sqlManager.getPageSqlScript(target, this.executeContext.sqlId);
        Map mapParas = this.beforeExecute(target, paras, false);
        this.executeContext.sqlManager.getDbStyle().getRangeSql().addTemplateRangeParas(mapParas, start, size);
        return newSqlEx.select(target, mapParas);
    }

    @Override
    public long selectCount(Object paras) {
        return this.singleSelect(Long.class, paras);
    }

    @Override
    public int update(Class target, Object object) {
        Map paras = this.beforeExecute(target, object, true);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        int rs = 0;
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        try {
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            ruh = this.dbUpdate(conn, sql, objs);
            rs = (Integer)ruh.resultSet;
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ruh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public int[] insertBatch(Class<?> target, List<?> list) {
        if (list.size() == 0) {
            return new int[0];
        }
        int[] rs = null;
        Statement ps = null;
        Connection conn = null;
        InterceptorContext ctx = new InterceptorContext(this.executeContext);
        GroupBatchExecutor groupBatchExecutor = new GroupBatchExecutor();
        try {
            Object firstValue = list.get(0);
            KeyHolder holder = KeyHolder.getKeyHolderByClass(firstValue);
            for (int k = 0; k < list.size(); ++k) {
                Object entity = list.get(k);
                if (entity == null) {
                    throw new NullPointerException("\u5217\u8868 " + k + "\u4e3a\u7a7a");
                }
                this.addParaIfAssignId(entity);
                Map paras = this.beforeExecute(target, entity, true);
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                if (ps == null) {
                    conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
                    ps = holder.hasAttr() ? conn.prepareStatement(result.jdbcSql, this.getKeyHolderCols(holder, entity.getClass())) : conn.prepareStatement(result.jdbcSql);
                    this.applyStatementSetting(this.executeContext, conn, ps);
                    ctx = this.callInterceptorAsBefore(paras);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
                groupBatchExecutor.addSql(result, (PreparedStatement)ps);
            }
            rs = groupBatchExecutor.executeBatch(this.executeContext, ctx, this.executeContext.sqlManager.isBatchLogOneByOne());
            if (this.executeContext.sqlManager.getDbStyle().batchGeneratedKeysSupport() && holder.hasAttr()) {
                ResultSet keysSet = ps.getGeneratedKeys();
                String[] attrs = holder.getAttrNames();
                int index = 0;
                while (keysSet.next()) {
                    Object entity = list.get(index);
                    for (int i = 0; i < attrs.length; ++i) {
                        Object value = keysSet.getObject(i + 1);
                        BeanKit.setBeanPropertyWithCast(entity, (Object)value, (String)attrs[i]);
                    }
                    ++index;
                }
                keysSet.close();
            }
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public int[] updateBatch(Class<?> target, List<?> list) {
        if (list.isEmpty()) {
            return new int[0];
        }
        Connection conn = null;
        InterceptorContext ctx = new InterceptorContext(this.executeContext);
        try {
            GroupBatchExecutor groupBatchExecutor = new GroupBatchExecutor();
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            for (int k = 0; k < list.size(); ++k) {
                if (list.get(k) == null) {
                    throw new NullPointerException("\u5217\u8868 " + k + "\u53c2\u6570\u4e3a\u7a7a");
                }
                this.addParam2BatchExecutor(target, list.get(k), conn, groupBatchExecutor, true);
            }
            int[] nArray = groupBatchExecutor.executeBatch(this.executeContext, ctx, this.executeContext.sqlManager.isBatchLogOneByOne());
            this.clean(this.executeContext, conn);
            return nArray;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(this.executeContext, conn);
                throw throwable;
            }
        }
    }

    @Override
    public int[] executeBatch(List<SqlIdWithParam> list, Integer batchSize) {
        if (ListUtil.isEmpty(list)) {
            return new int[0];
        }
        batchSize = batchSize == null ? 1000 : batchSize;
        Connection conn = null;
        InterceptorContext ctx = new InterceptorContext(this.executeContext);
        try {
            GroupBatchExecutor groupBatchExecutor = new GroupBatchExecutor();
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            int[] rows = new int[list.size()];
            List batchList = ListUtil.partition(list, (int)batchSize);
            for (List batch : batchList) {
                for (int k = 0; k < batch.size(); ++k) {
                    SqlIdWithParam item = (SqlIdWithParam)batch.get(k);
                    if (item == null) {
                        throw new NullPointerException("\u5217\u8868 " + k + "\u53c2\u6570\u4e3a\u7a7a");
                    }
                    SQLSource sqlSource = this.executeContext.sqlManager.getSqlLoader().querySQL(item.getSqlId());
                    this.executeContext.initSQLSource(sqlSource);
                    Object sqlParams = item.getSqlParam();
                    boolean isUpdate = sqlSource.getSqlType().isUpdate();
                    if (sqlParams instanceof List) {
                        List sqlParamList = (List)sqlParams;
                        for (Object param : sqlParamList) {
                            this.addParam2BatchExecutor(null, param, conn, groupBatchExecutor, isUpdate);
                        }
                        continue;
                    }
                    this.addParam2BatchExecutor(null, item.getSqlParam(), conn, groupBatchExecutor, isUpdate);
                }
                int[] group = groupBatchExecutor.executeBatch(this.executeContext, ctx, this.executeContext.sqlManager.isBatchLogOneByOne());
                rows = ArrayKit.concatAll((int[])rows, (int[][])new int[][]{group});
            }
            Object object = rows;
            this.clean(this.executeContext, conn);
            return object;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(this.executeContext, conn);
                throw throwable;
            }
        }
    }

    private void addParam2BatchExecutor(Class<?> target, Object param, Connection conn, GroupBatchExecutor groupBatchExecutor, boolean isUpdate) throws SQLException {
        Map paras = this.beforeExecute(target, param, isUpdate);
        SQLResult result = this.run(paras);
        PreparedStatement ps = groupBatchExecutor.containSql(result.jdbcSql);
        if (ps == null) {
            ps = conn.prepareStatement(result.jdbcSql);
        }
        this.applyStatementSetting(this.executeContext, conn, ps);
        this.setPreparedStatementPara(ps, result.jdbcPara);
        ps.addBatch();
        groupBatchExecutor.addSql(result, ps);
    }

    @Override
    public int[] updateBatch(List<?> list) {
        return this.updateBatch(null, list);
    }

    @Override
    public <T> T unique(Class<T> target, Object objId) {
        return this.single(target, objId, true);
    }

    @Override
    public <T> T single(Class<T> target, Object objId) {
        return this.single(target, objId, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T single(Class<T> clazz, Object objId, boolean throwException) {
        this.executeContext.target = clazz;
        SQLManager sqlManager = this.executeContext.sqlManager;
        MetadataManager mm = sqlManager.getMetaDataManager();
        TableDesc table = mm.getTable(sqlManager.getNc().getTableName(clazz));
        ClassDesc classDesc = table.genClassDesc(clazz, sqlManager.getNc());
        Map paras = this.beforeExecute(clazz, objId, false);
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        if (this.executeContext.executeResult != null) {
            this.callInterceptorAsAfter(ctx, this.executeContext.executeResult);
            return (T)this.executeContext.executeResult;
        }
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        Connection conn = null;
        ResultSetHolder rsh = null;
        try {
            conn = sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sql, objs);
            Object model = null;
            if (this.executeContext.customizedBeanProcessor != null) {
                resultList = this.executeContext.customizedBeanProcessor.toBeanList(this.executeContext, rsh.resultSet, clazz);
            } else {
                ResultSetMapper<?> resultSetMapper;
                ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
                RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
                ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
                if (resultSetMapper != null) {
                    resultList = resultSetMapper.mapping(this.executeContext, clazz, rsh.resultSet, classAnnotation.getMapperConfig());
                } else if (rowMapper != null) {
                    BeanProcessor beanProcessor = this.getBeanProcessor();
                    resultList = new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, rsh.resultSet, (Class)clazz, classAnnotation.getMapperConfig());
                } else {
                    resultList = this.mappingSelect(clazz, rsh.resultSet);
                }
            }
            if (resultList.isEmpty()) {
                if (throwException) {
                    throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6 " + objId);
                }
            } else {
                model = resultList.get(0);
            }
            this.executeContext.executeResult = model;
            this.callInterceptorAsAfter(ctx, model);
            Object object = this.afterBean(model);
            this.clean(false, conn, rsh);
            return (T)object;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
                catch (BeetlSQLException beetlSQLException) {
                    this.callInterceptorAsException(ctx, (Exception)((Object)beetlSQLException));
                    throw beetlSQLException;
                }
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
    }

    @Override
    public boolean existById(Class clazz, Object objId) {
        SQLManager sqlManager = this.executeContext.sqlManager;
        MetadataManager mm = sqlManager.getMetaDataManager();
        TableDesc table = mm.getTable(sqlManager.getNc().getTableName(clazz));
        ClassDesc classDesc = table.genClassDesc(clazz, sqlManager.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        if (this.executeContext.executeResult != null) {
            this.callInterceptorAsAfter(ctx, this.executeContext.executeResult);
            return (Boolean)this.executeContext.executeResult;
        }
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        Connection conn = null;
        ResultSetHolder rsh = null;
        boolean hasResult = false;
        try {
            conn = sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sql, objs);
            rsh.resultSet.next();
            int count = rsh.resultSet.getInt(1);
            hasResult = count != 0;
            this.executeContext.executeResult = count;
            this.callInterceptorAsAfter(ctx, hasResult);
            this.clean(false, conn, rsh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
        return hasResult;
    }

    @Override
    public int deleteById(Class<?> clazz, Object objId) {
        SQLManager sqlManager = this.executeContext.sqlManager;
        MetadataManager mm = sqlManager.getMetaDataManager();
        TableDesc table = mm.getTable(sqlManager.getNc().getTableName(clazz));
        ClassDesc classDesc = table.genClassDesc(clazz, sqlManager.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        int rs = 0;
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        try {
            conn = sqlManager.getDs().getConn(this.executeContext, true);
            ruh = this.dbUpdate(conn, sql, objs);
            rs = (Integer)ruh.resultSet;
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ruh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public <T> List<T> sqlReadySelect(Class<T> clazz, SQLReady p) {
        SQLResult sqlResult;
        this.executeContext.sqlResult = sqlResult = new SQLResult(p.sql, p.args);
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.beforeExecute(clazz, Arrays.asList(p.getArgs()), false));
        Connection conn = null;
        ResultSetHolder rsh = null;
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sqlResult.jdbcSql, sqlResult.jdbcPara);
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            if (resultSetMapper != null) {
                resultList = resultSetMapper.mapping(this.executeContext, clazz, rsh.resultSet, classAnnotation.getMapperConfig());
            } else if (rowMapper != null) {
                BeanProcessor beanProcessor = this.getBeanProcessor();
                resultList = new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, rsh.resultSet, (Class)clazz, classAnnotation.getMapperConfig());
            } else {
                resultList = this.mappingSelect(clazz, rsh.resultSet);
            }
            this.executeContext.executeResult = resultList;
            resultList = (List)this.afterBean(resultList);
            this.callInterceptorAsAfter(ctx, resultList);
            Object object = resultList;
            this.clean(false, conn, rsh);
            return object;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
    }

    @Override
    public <T> StreamData<T> streamExecute(Class<T> clazz, SQLReady p) {
        SQLResult sqlResult;
        this.executeContext.sqlResult = sqlResult = new SQLResult(p.sql, p.args);
        Object resultList = null;
        Connection conn = null;
        ResultSetHolder rsh = null;
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sqlResult.jdbcSql, sqlResult.jdbcPara);
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            if (resultSetMapper != null) {
                throw new UnsupportedOperationException("stream\u67e5\u8be2\u4e0d\u652f\u6301ResultSetMapper");
            }
            StreamData<T> data = new StreamData<T>(rsh.resultSet, this.executeContext, clazz);
            if (rowMapper != null) {
                data.setRowMapper(rowMapper, classAnnotation.getMapperConfig());
            }
            return data;
        }
        catch (SQLException e) {
            this.clean(false, conn, rsh);
            throw new BeetlSQLException(1, (Throwable)e);
        }
    }

    @Override
    public <T> StreamData<T> stream(Class<T> clazz, Object obj) {
        Map paras = this.beforeExecute(clazz, obj, false);
        SQLResult result = this.run(paras);
        ResultSetHolder rsh = null;
        Connection conn = null;
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, result.jdbcSql, result.jdbcPara);
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            if (resultSetMapper != null) {
                throw new UnsupportedOperationException("stream\u67e5\u8be2\u4e0d\u652f\u6301ResultSetMapper");
            }
            StreamData<T> data = new StreamData<T>(rsh.resultSet, this.executeContext, clazz);
            if (rowMapper != null) {
                data.setRowMapper(rowMapper, classAnnotation.getMapperConfig());
            }
            return data;
        }
        catch (SQLException e) {
            this.clean(false, conn, rsh);
            throw new BeetlSQLException(1, (Throwable)e);
        }
    }

    @Override
    public int sqlReadyExecuteUpdate(SQLReady p) {
        SQLResult sqlResult;
        this.executeContext.sqlResult = sqlResult = new SQLResult(p.sql, p.args);
        InterceptorContext ctx = this.callInterceptorAsBefore(this.beforeExecute(null, Arrays.asList(p.getArgs()), true));
        int rs = 0;
        Connection conn = null;
        ResultUpdateHolder rsh = null;
        try {
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            rsh = this.dbUpdate(conn, sqlResult.jdbcSql, sqlResult.jdbcPara);
            rs = (Integer)rsh.resultSet;
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, rsh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, rsh);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public int[] sqlReadyBatchExecuteUpdate(SQLBatchReady batch) {
        List<Object[]> args = batch.getArgs();
        if (args.isEmpty()) {
            return new int[0];
        }
        InterceptorContext ctx = new InterceptorContext(this.executeContext);
        Connection conn = null;
        PreparedStatement ps = null;
        GroupBatchExecutor groupBatchExecutor = new GroupBatchExecutor();
        try {
            int[] ret;
            for (int i = 0; i < args.size(); ++i) {
                Object[] jdbcArgs = args.get(i);
                SQLResult sqlResult = new SQLResult(batch.sql, jdbcArgs);
                sqlResult.jdbcSql = batch.sql;
                this.executeContext.sqlResult = sqlResult;
                if (i == 0) {
                    conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
                    ctx = this.callInterceptorAsBefore(this.beforeExecute(null, Arrays.asList(jdbcArgs), true));
                    ps = conn.prepareStatement(sqlResult.jdbcSql);
                }
                this.setPreparedStatementPara(ps, sqlResult.jdbcPara);
                ps.addBatch();
                groupBatchExecutor.addSql(sqlResult, ps);
            }
            int[] nArray = ret = groupBatchExecutor.executeBatch(this.executeContext, ctx, this.executeContext.sqlManager.isBatchLogOneByOne());
            return nArray;
        }
        catch (SQLException e) {
            this.callInterceptorAsException(ctx, e);
            throw new BeetlSQLException(1, (Throwable)e);
        }
        finally {
            this.clean(true, conn, ps);
        }
    }

    @Override
    public int executeCall(CallReady callReady) {
        Connection conn = null;
        CallableStatement call = null;
        try {
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            call = conn.prepareCall(callReady.getSql());
            this.configCall(call, callReady);
            int ret = call.executeUpdate();
            for (CallArg arg : callReady.getArgs()) {
                if (!(arg instanceof OutArg)) continue;
                OutArg outArg = (OutArg)arg;
                Object value = call.getObject(outArg.getIndex(), outArg.getOutType());
                outArg.setOutValue(value);
            }
            int n = ret;
            this.clean(true, conn, call);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, call);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> executeCall(CallReady callReady, Class<T> clazz) {
        Connection conn = null;
        CallableStatement call = null;
        BeanProcessor beanProcessor = this.getBeanProcessor();
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            call = conn.prepareCall(callReady.getSql());
            this.configCall(call, callReady);
            ResultSet ret = call.executeQuery();
            Object resultList = null;
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            resultList = resultSetMapper != null ? resultSetMapper.mapping(this.executeContext, clazz, ret, classAnnotation.getMapperConfig()) : (rowMapper != null ? new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, ret, (Class)clazz, classAnnotation.getMapperConfig()) : this.mappingSelect(clazz, ret));
            this.executeContext.executeResult = resultList;
            resultList = (List)this.afterBean(resultList);
            for (CallArg arg : callReady.getArgs()) {
                if (!(arg instanceof OutArg)) continue;
                OutArg outArg = (OutArg)arg;
                Object value = call.getObject(outArg.getIndex(), outArg.getOutType());
                outArg.setOutValue(value);
            }
            Object object = resultList;
            this.clean(true, conn, call);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, call);
                throw throwable;
            }
        }
    }

    protected void configCall(CallableStatement call, CallReady callReady) throws SQLException {
        List<CallArg> list = callReady.getArgs();
        BeanProcessor beanProcessor = this.getBeanProcessor();
        for (CallArg arg : list) {
            if (arg instanceof InArg) {
                InArg inArg = (InArg)arg;
                if (inArg.hasJdbcType()) {
                    call.setObject(arg.getIndex(), (Object)inArg, (int)inArg.getJdbcType());
                    continue;
                }
                call.setObject(arg.getIndex(), inArg.getArg());
                continue;
            }
            OutArg outArg = (OutArg)arg;
            if (outArg.hasJdbcType()) {
                call.registerOutParameter(arg.getIndex(), (int)outArg.getJdbcType());
                continue;
            }
            JavaSqlTypeHandler sqlTypeHandler = beanProcessor.getHandler(outArg.getOutType());
            if (sqlTypeHandler == null) {
                throw new UnsupportedOperationException("\u4e0d\u80fd\u6839\u636e" + outArg.getOutType() + " \u5224\u65ad\u51fa\u53c2\u7c7b\u578b\uff0c\u9700\u8981\u6307\u793ajdbc type" + arg.getIndex());
            }
            call.registerOutParameter(arg.getIndex(), sqlTypeHandler.jdbcType());
        }
    }

    @Override
    public ExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    protected void setIdsParas(ClassDesc desc, Object obj, Map<String, Object> paras) {
        List<String> idAttrs = desc.getIdAttrs();
        if (idAttrs.size() == 1) {
            paras.put(idAttrs.get(0), obj);
        } else {
            Map<String, Object> map = desc.getIdMethods();
            for (int i = 0; i < idAttrs.size(); ++i) {
                String idCol = idAttrs.get(i);
                String idAttr = idAttrs.get(i);
                Method m = (Method)map.get(idAttr);
                try {
                    Object os = m.invoke(obj, new Object[0]);
                    paras.put(idAttr, os);
                    continue;
                }
                catch (Exception ex) {
                    throw new BeetlSQLException(14, "\u65e0\u6cd5\u8bbe\u7f6e\u590d\u5408\u4e3b\u952e:" + idCol, (Throwable)ex);
                }
            }
        }
    }

    protected int insert(Object paras, KeyHolder holder) {
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        InterceptorContext ctx = null;
        try {
            this.addParaIfAssignId(paras);
            Map map = this.beforeExecute(paras.getClass(), paras, true);
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> jdbcPara = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(map);
            sql = this.executeContext.sqlResult.jdbcSql;
            jdbcPara = this.executeContext.sqlResult.jdbcPara;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            boolean holderHasAttr = holder.hasAttr();
            String[] cols = holderHasAttr ? this.getKeyHolderCols(holder, paras.getClass()) : null;
            ruh = this.dbUpdateWithHolder(conn, sql, jdbcPara, cols);
            if (!this.executeContext.sqlManager.getDbStyle().generatedKeysSupport()) {
                if (holderHasAttr) {
                    int length = holder.getAttrNames().length;
                    Object[] values = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        values[i] = null;
                    }
                    holder.setValues(values);
                }
            } else if (holderHasAttr) {
                this.handleHolder(ruh.statement, holder);
            }
            int ret = (Integer)ruh.resultSet;
            this.executeContext.executeResult = ret;
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ruh);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
    }

    protected void clean(boolean isUpdate, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.closeConnection(conn, isUpdate);
    }

    protected void clean(boolean isUpdate, Connection conn, Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            this.closeConnection(conn, isUpdate);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeConnection(Connection conn, boolean isUpdate) {
        this.executeContext.sqlManager.getDs().closeConnection(conn, this.executeContext, isUpdate);
    }

    protected ResultSetHolder dbQuery(Connection conn, String sql, List<SQLParameter> jdbcPara) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        this.applyStatementSetting4Framework(this.executeContext, conn, ps);
        this.applyStatementSetting(this.executeContext, conn, ps);
        this.setPreparedStatementPara(ps, jdbcPara);
        ResultSet rs = ps.executeQuery();
        this.applyResultSetting4Framework(this.executeContext, conn, rs);
        this.applyResultSetting(this.executeContext, conn, rs);
        return new ResultSetHolder(ps, rs);
    }

    protected ResultUpdateHolder dbUpdate(Connection conn, String sql, List<SQLParameter> jdbcPara) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        this.applyStatementSetting4Framework(this.executeContext, conn, ps);
        this.applyStatementSetting(this.executeContext, conn, ps);
        this.setPreparedStatementPara(ps, jdbcPara);
        int result = ps.executeUpdate();
        return new ResultUpdateHolder(ps, result);
    }

    protected ResultUpdateHolder dbUpdateWithHolder(Connection conn, String sql, List<SQLParameter> jdbcPara, String[] cols) throws SQLException {
        PreparedStatement ps = null;
        ps = cols != null ? conn.prepareStatement(sql, cols) : conn.prepareStatement(sql);
        this.setPreparedStatementPara(ps, jdbcPara);
        int result = ps.executeUpdate();
        return new ResultUpdateHolder(ps, result);
    }

    protected void clean(ExecuteContext executeContext, Connection conn) {
        this.clean(true, conn, (Closeable)null);
    }

    protected void handleHolder(Statement ps, KeyHolder holder) throws SQLException {
        ResultSet rs = ps.getGeneratedKeys();
        if (rs.next()) {
            int length = holder.getAttrNames().length;
            Object[] values = new Object[length];
            for (int i = 0; i < length; ++i) {
                values[i] = rs.getObject(i + 1);
            }
            holder.setValues(values);
        }
        rs.close();
    }

    protected void assignKeyHolder(KeyHolder holder, Object paras) {
        if (paras instanceof Map) {
            return;
        }
        String[] attrs = holder.getAttrNames();
        Object[] values = holder.getValues();
        int len = attrs.length;
        for (int i = 0; i < len; ++i) {
            BeanKit.setBeanPropertyWithCast((Object)paras, (Object)values[i], (String)attrs[i]);
        }
    }

    private void addParaIfAssignId(Object obj) {
        if (obj instanceof Map) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (!(this.executeContext.sqlSource instanceof SQLTableSource)) {
            return;
        }
        Class clz = this.executeContext.target;
        SQLTableSource tableSource = (SQLTableSource)this.executeContext.sqlSource;
        if (tableSource.getIdType() == 1 && tableSource.getAssignIds() != null) {
            Map<String, AssignID> ids = tableSource.getAssignIds();
            for (Map.Entry<String, AssignID> entry : ids.entrySet()) {
                String attrName = entry.getKey();
                Object value = BeanKit.getBeanProperty((Object)obj, (String)attrName);
                if (!StringKit.isNullOrEmpty((Object)value)) continue;
                AssignID assignId = entry.getValue();
                String algorithm = assignId.value();
                if (StringKit.isEmpty((String)algorithm)) {
                    throw new BeetlSQLException(7, "\u4f7f\u7528@Assign\u672a\u6307\u5b9a\u7b97\u6cd5\uff0c\u9700\u8981\u663e\u793a\u7684\u8d4b\u503c\u7ed9 " + attrName);
                }
                String param = assignId.param();
                Object o = this.executeContext.sqlManager.getAssignIdByIdAutoGen(algorithm, param, tableSource.getTableDesc().getName());
                BeanKit.setBeanProperty((Object)obj, (Object)o, (String)attrName);
            }
        }
    }

    protected String[] getKeyHolderCols(KeyHolder holder, Class target) {
        String[] attrs = holder.getAttrNames();
        String[] cols = new String[attrs.length];
        NameConversion nc = this.executeContext.sqlManager.getNc();
        for (int i = 0; i < attrs.length; ++i) {
            cols[i] = nc.getColName(target, attrs[i]);
        }
        return cols;
    }

    protected void setPreparedStatementPara(PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        if (objs.isEmpty()) {
            return;
        }
        BeanProcessor beanProcessor = this.getBeanProcessor();
        beanProcessor.setPreparedStatementPara(this.executeContext, ps, objs);
    }

    private BeanProcessor getBeanProcessor() {
        return this.executeContext.sqlManager.getDefaultBeanProcessors();
    }

    @Override
    public Map beforeExecute(Class target, Object paras, boolean isUpdate) {
        this.executeContext.target = target;
        this.executeContext.inputParas = paras;
        this.executeContext.isUpdate = isUpdate;
        if (paras == null) {
            HashMap map = new HashMap();
            this.addMoreParasFromTarget(target, map);
            return map;
        }
        if (paras instanceof Map) {
            Map map = (Map)paras;
            this.addMoreParasFromTarget(target, map);
            return map;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        Class<?> parasType = paras.getClass();
        if (BaseSQLExecutor.isBaseDataType(paras.getClass())) {
            return map;
        }
        ClassAnnotation an = ClassAnnotation.getClassAnnotation(parasType);
        if (an.isContainExtAnnotation()) {
            BeanConvert beanConvert;
            ClassExtAnnotation ext = an.getExtAnnotation();
            if (ext.hasAttributeExt()) {
                Map<String, AttributeConvert> attrMap = ext.getAttributeConvertMap();
                for (Map.Entry<String, AttributeConvert> entry : attrMap.entrySet()) {
                    String attr = entry.getKey();
                    AttributeConvert convert = entry.getValue();
                    Object newValue = convert.toDb(this.executeContext, parasType, attr, paras);
                    map.put(attr, newValue);
                }
            }
            if (ext.hasEntityExt() && (beanConvert = ext.getBeanConvert()) != null) {
                Object obj = beanConvert.before(this.executeContext, paras, ext.getBeanConvertAnnotation());
                if (obj instanceof Map) {
                    map.putAll((Map)obj);
                } else {
                    map.put("_root", obj);
                }
            }
        }
        this.addMoreParasFromTarget(target, map);
        return map;
    }

    protected void addMoreParasFromTarget(Class target, Map map) {
        TargetAdditional targetAdditional;
        Map<String, Object> moreParas;
        ClassExtAnnotation targetExtClassAnnotation;
        Annotation annotation;
        Map extPara = this.executeContext.sqlManager.getSqlManagerExtend().getParaExtend().morePara(this.executeContext);
        if (extPara != null) {
            map.putAll(extPara);
        }
        if (target == null) {
            return;
        }
        ClassAnnotation targetClassAnnotation = ClassAnnotation.getClassAnnotation(target);
        if (targetClassAnnotation.isContainExtAnnotation() && (annotation = (targetExtClassAnnotation = targetClassAnnotation.getExtAnnotation()).getAdditionalAnnotation()) != null && (moreParas = (targetAdditional = targetExtClassAnnotation.getTargetAdditional()).getAdditional(this.executeContext, annotation)) != null && !moreParas.isEmpty()) {
            map.putAll(moreParas);
        }
    }

    @Override
    public SQLResult run(Map<String, Object> parasMap) {
        return this.run(parasMap, null);
    }

    @Override
    public SQLResult run(Map<String, Object> parasMap, TemplateContext ctx) {
        String jdbcSql;
        SQLTemplateEngine gt = this.executeContext.sqlManager.sqlTemplateEngine;
        SQLTemplate t = null;
        ExecuteContext parentExecuteContext = ctx == null ? null : (ExecuteContext)ctx.getVar("_executeContext");
        t = parentExecuteContext != null ? gt.getSqlTemplate(this.executeContext.sqlId, ctx) : gt.getSqlTemplate(this.executeContext.sqlId);
        LinkedList<SQLParameter> jdbcPara = new LinkedList<SQLParameter>();
        if (parasMap != null) {
            for (Map.Entry<String, Object> entry : parasMap.entrySet()) {
                t.setPara(entry.getKey(), entry.getValue());
            }
        }
        t.setPara("_paras", jdbcPara);
        t.setPara("_executeContext", this.executeContext);
        this.executeContext.sqlResult.jdbcSql = jdbcSql = t.render();
        this.executeContext.sqlResult.jdbcPara = jdbcPara;
        SQLResult result = new SQLResult();
        result.jdbcSql = jdbcSql;
        result.jdbcPara = jdbcPara;
        result.templateContext = t.getContext();
        return result;
    }

    protected InterceptorContext callInterceptorAsBefore(Map<String, Object> inputParas) {
        Interceptor[] inters = this.executeContext.sqlManager.inters;
        if (inters.length > 0) {
            InterceptorContext ctx = new InterceptorContext(this.executeContext);
            for (Interceptor in : inters) {
                in.before(ctx);
            }
            return ctx;
        }
        return null;
    }

    protected void callInterceptorAsAfter(InterceptorContext ctx, Object result) {
        if (ctx == null) {
            return;
        }
        for (Interceptor in : this.executeContext.sqlManager.inters) {
            in.after(ctx);
        }
    }

    protected void callInterceptorAsException(InterceptorContext ctx, Exception ex) {
        if (ctx == null) {
            return;
        }
        for (Interceptor in : this.executeContext.sqlManager.inters) {
            in.exception(ctx, ex);
        }
    }

    protected Object afterBean(Object result) {
        BeanFetch beanFetch;
        BeanConvert convert;
        if (result == null) {
            return null;
        }
        Class target = this.executeContext.target;
        if (target == null) {
            return result;
        }
        if (target == Map.class) {
            return result;
        }
        if (BaseSQLExecutor.isBaseDataType(target)) {
            return result;
        }
        ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(target);
        ClassExtAnnotation extAnnotation = classAnnotation.getExtAnnotation();
        if (extAnnotation != null && extAnnotation.getBeanConvert() != null && (convert = extAnnotation.getBeanConvert()) != null) {
            Annotation annotation = extAnnotation.getBeanConvertAnnotation();
            if (result instanceof List) {
                List resultList = (List)result;
                resultList.forEach(obj -> convert.after(this.executeContext, obj, annotation));
            } else {
                convert.after(this.executeContext, result, annotation);
            }
        }
        if ((beanFetch = classAnnotation.getBeanFetch()) != null) {
            if (result instanceof List) {
                List resultList = (List)result;
                beanFetch.fetchMore(this.executeContext, resultList, classAnnotation.getBeanFetchAnnotation());
            } else {
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(result);
                beanFetch.fetchMore(this.executeContext, list, classAnnotation.getBeanFetchAnnotation());
                result = list.get(0);
            }
        }
        return result;
    }

    protected void applyStatementSetting(ExecuteContext ctx, Connection conn, Statement statement) throws SQLException {
        this.getExecuteContext().sqlManager.getDbStyle().applyStatementSetting(ctx, conn, statement);
    }

    protected void applyResultSetting(ExecuteContext ctx, Connection conn, ResultSet rs) throws SQLException {
        this.getExecuteContext().sqlManager.getDbStyle().applyResultSetSetting(ctx, conn, rs);
    }

    protected void applyStatementSetting4Framework(ExecuteContext ctx, Connection conn, Statement statement) throws SQLException {
        this.getExecuteContext().sqlManager.getDs().applyStatementSetting(ctx, conn, statement);
    }

    protected void applyResultSetting4Framework(ExecuteContext ctx, Connection conn, ResultSet rs) throws SQLException {
        this.getExecuteContext().sqlManager.getDs().applyResultSetSetting(ctx, conn, rs);
    }

    public static class ResultUpdateHolder
    implements Closeable {
        Statement statement;
        Object resultSet;

        public ResultUpdateHolder(Statement statement, Object result) {
            this.statement = statement;
            this.resultSet = result;
        }

        @Override
        public void close() throws SQLException {
            if (this.statement != null) {
                this.statement.close();
            }
        }

        public Statement getStatement() {
            return this.statement;
        }

        public Object getResultSet() {
            return this.resultSet;
        }

        public void setStatement(Statement statement) {
            this.statement = statement;
        }

        public void setResultSet(Object resultSet) {
            this.resultSet = resultSet;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultUpdateHolder)) {
                return false;
            }
            ResultUpdateHolder other = (ResultUpdateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            if (this$statement == null ? other$statement != null : !this$statement.equals(other$statement)) {
                return false;
            }
            Object this$resultSet = this.getResultSet();
            Object other$resultSet = other.getResultSet();
            return !(this$resultSet == null ? other$resultSet != null : !this$resultSet.equals(other$resultSet));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResultUpdateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            Object $resultSet = this.getResultSet();
            result = result * 59 + ($resultSet == null ? 43 : $resultSet.hashCode());
            return result;
        }

        public String toString() {
            return "BaseSQLExecutor.ResultUpdateHolder(statement=" + this.getStatement() + ", resultSet=" + this.getResultSet() + ")";
        }
    }

    public static class ResultSetHolder
    implements Closeable {
        Statement statement;
        ResultSet resultSet;

        public ResultSetHolder(Statement statement, ResultSet resultSet) {
            this.statement = statement;
            this.resultSet = resultSet;
        }

        @Override
        public void close() throws SQLException {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
        }
    }

    static interface Closeable {
        public void close() throws SQLException;
    }

    static class GroupBatchExecutor {
        Map<String, PreparedStatement> batchPs = new HashMap<String, PreparedStatement>();
        Map<String, List<SQLParameter>> batchParameter = new HashMap<String, List<SQLParameter>>();
        List<Integer> allRet = new ArrayList<Integer>();

        GroupBatchExecutor() {
        }

        public void addSql(SQLResult result, PreparedStatement ps) {
            String sql = result.jdbcSql;
            if (!this.batchPs.keySet().contains(sql)) {
                this.batchPs.put(sql, ps);
                this.batchParameter.put(sql, new ArrayList());
            }
            SQLParameter specialParameter = new SQLParameter(result.jdbcPara);
            this.batchParameter.get(result.jdbcSql).add(specialParameter);
        }

        public PreparedStatement containSql(String sql) {
            return this.batchPs.get(sql);
        }

        public int[] executeBatch(ExecuteContext executeContext, InterceptorContext ctx, boolean singleUpdate) throws SQLException {
            for (Map.Entry<String, PreparedStatement> entry : this.batchPs.entrySet()) {
                String sql;
                PreparedStatement ps = entry.getValue();
                executeContext.sqlResult.jdbcSql = sql = entry.getKey();
                if (singleUpdate) {
                    int[] rs = new int[]{};
                    List<SQLParameter> list = this.batchParameter.get(sql);
                    for (int i = 0; i < list.size(); ++i) {
                        SQLParameter sqlParameter = list.get(i);
                        executeContext.sqlResult.jdbcPara = (List)sqlParameter.value;
                        for (Interceptor in : executeContext.sqlManager.getInters()) {
                            in.before(ctx);
                        }
                        if (rs.length == 0) {
                            rs = ps.executeBatch();
                            this.addRet(rs);
                        }
                        executeContext.executeResult = rs[i];
                        Interceptor[] interceptorArray = executeContext.sqlManager.inters;
                        int n = interceptorArray.length;
                        for (int j = 0; j < n; ++j) {
                            Interceptor in;
                            in = interceptorArray[j];
                            in.after(ctx);
                        }
                    }
                    continue;
                }
                SQLParameter sqlParameter = this.batchParameter.get(sql).get(0);
                List sqlParameters = (List)sqlParameter.value;
                executeContext.sqlResult.jdbcPara = (List)sqlParameter.value;
                for (Interceptor in : executeContext.sqlManager.getInters()) {
                    in.before(ctx);
                }
                int[] rs = ps.executeBatch();
                this.addRet(rs);
                executeContext.executeResult = rs[0];
                for (Interceptor in : executeContext.sqlManager.inters) {
                    in.after(ctx);
                }
            }
            return this.allRet();
        }

        public void addRet(int[] rets) {
            for (int i = 0; i < rets.length; ++i) {
                this.allRet.add(rets[i]);
            }
        }

        public int[] allRet() {
            int[] ints = this.allRet.stream().mapToInt(Integer::valueOf).toArray();
            return ints;
        }
    }
}

