/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.call;

import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.call.CallArg;
import org.beetl.sql.core.call.InArg;
import org.beetl.sql.core.call.OutArg;

public class CallReady {
    String sql;
    int index;
    SqlId sqlId = null;
    List<CallArg> args = new ArrayList<CallArg>(32);

    public CallReady(String sql) {
        this.sql = sql;
        this.index = 1;
    }

    public CallReady(String sql, Object ... args) {
        this.sql = sql;
        this.index = 1;
        for (Object o : args) {
            this.add(new InArg(o));
        }
    }

    public CallReady(SqlId sqlId, String sql, Object ... args) {
        this.sql = sql;
        this.index = 1;
        this.sqlId = sqlId;
        for (Object o : args) {
            this.add(new InArg(o));
        }
    }

    public CallReady add(CallArg callArg) {
        this.args.add(callArg);
        callArg.setIndex(this.index);
        ++this.index;
        return this;
    }

    public CallReady add(int index, CallArg callArg) {
        this.args.add(index - 1, callArg);
        callArg.setIndex(index);
        return this;
    }

    public Object getOutValue(int index) {
        CallArg callArg = this.args.get(index - 1);
        if (!(callArg instanceof OutArg)) {
            throw new IllegalArgumentException("\u9700\u8981\u6307\u5b9a\u4e00\u4e2aOut\u7d22\u5f15 " + index);
        }
        return ((OutArg)callArg).getOutValue();
    }

    public String getSql() {
        return this.sql;
    }

    public int getIndex() {
        return this.index;
    }

    public SqlId getSqlId() {
        return this.sqlId;
    }

    public List<CallArg> getArgs() {
        return this.args;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setSqlId(SqlId sqlId) {
        this.sqlId = sqlId;
    }

    public void setArgs(List<CallArg> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallReady)) {
            return false;
        }
        CallReady other = (CallReady)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        SqlId this$sqlId = this.getSqlId();
        SqlId other$sqlId = other.getSqlId();
        if (this$sqlId == null ? other$sqlId != null : !((Object)this$sqlId).equals(other$sqlId)) {
            return false;
        }
        List<CallArg> this$args = this.getArgs();
        List<CallArg> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallReady;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        SqlId $sqlId = this.getSqlId();
        result = result * 59 + ($sqlId == null ? 43 : ((Object)$sqlId).hashCode());
        List<CallArg> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public String toString() {
        return "CallReady(sql=" + this.getSql() + ", index=" + this.getIndex() + ", sqlId=" + this.getSqlId() + ", args=" + this.getArgs() + ")";
    }
}

