/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import org.beetl.sql.clazz.kit.KeyWordHandler;
import org.beetl.sql.core.concat.ConcatContext;

public class ConcatBuilder {
    ConcatContext ctx;
    StringBuilder sb = new StringBuilder();

    public ConcatBuilder(ConcatContext ctx) {
        this.ctx = ctx;
    }

    public ConcatBuilder appendCol(String colName) {
        KeyWordHandler kh = this.ctx.keyWordHandler;
        String col = kh.getCol(colName);
        this.sb.append(col).append(" ");
        return this;
    }

    public ConcatBuilder appendTable(String tableName) {
        KeyWordHandler kh = this.ctx.keyWordHandler;
        String table = kh.getTable(tableName);
        this.sb.append(table).append(" ");
        return this;
    }

    public ConcatBuilder appendTable(Class table) {
        String tableName = this.ctx.nc.getTableName(table);
        return this.appendTable(tableName);
    }

    public ConcatBuilder comma() {
        this.sb.append(",");
        return this;
    }

    public ConcatBuilder assign() {
        this.sb.append("=");
        return this;
    }

    public ConcatBuilder valueHolder() {
        this.sb.append("?");
        return this;
    }

    public ConcatBuilder leftBracket() {
        this.sb.append("(");
        return this;
    }

    public ConcatBuilder rightBracket() {
        this.sb.append(")");
        return this;
    }

    public ConcatBuilder cr() {
        this.sb.append("\n");
        return this;
    }

    public ConcatBuilder appendVar(String var) {
        this.ctx.templateEngine.genVar(this, var);
        return this;
    }

    public String getVarString(String var) {
        return this.ctx.templateEngine.appendVar(var);
    }

    public ConcatBuilder testVar(String varName, String col) {
        this.ctx.templateEngine.genTestVar(this, varName, col);
        return this;
    }

    public ConcatBuilder testVarOrDefault(String varName, String defaultValue) {
        this.ctx.templateEngine.genTestVarOrDefault(this, varName, defaultValue);
        return this;
    }

    public ConcatBuilder testVar(String varName) {
        this.ctx.templateEngine.genTestVar(this, varName);
        return this;
    }

    public ConcatBuilder testRealVar(String varName, String realVal) {
        this.ctx.templateEngine.genTestRealVar(this, varName, realVal);
        return this;
    }

    public ConcatBuilder appendTrimStart() {
        this.cr();
        this.ctx.templateEngine.genTrimStart(this);
        return this;
    }

    public ConcatBuilder appendTrimStart(String keyword) {
        this.cr();
        this.ctx.templateEngine.genTrimStart(this, keyword);
        return this;
    }

    public ConcatBuilder appendTrimEnd() {
        this.cr();
        this.ctx.templateEngine.genTrimEnd(this);
        return this;
    }

    public ConcatBuilder appendIfNotEmptyStart(String name) {
        this.cr();
        this.ctx.templateEngine.genIfNotEmptyStart(this, name);
        return this;
    }

    public ConcatBuilder appendIfNotEmptyEnd() {
        this.cr();
        this.ctx.templateEngine.genIfNotEmptyEnd(this);
        return this;
    }

    public ConcatBuilder appendForStart(String collection, String var) {
        this.cr();
        this.ctx.templateEngine.genForStart(this, collection, var);
        return this;
    }

    public ConcatBuilder appendForEnd() {
        this.cr();
        this.ctx.templateEngine.genForEnd(this);
        return this;
    }

    public ConcatBuilder append(String str) {
        this.sb.append(str).append(" ");
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public ConcatContext getCtx() {
        return this.ctx;
    }
}

