/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.clazz.kit.KeyWordHandler;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.MSSqlServerMetadataManager;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.core.range.RangeSql;

public class SqlServerStyle
extends AbstractDBStyle {
    private SqlServerRange sqlServerRange = null;
    private boolean fetchRemark = true;

    public SqlServerStyle() {
        this.keyWordHandler = new KeyWordHandler(){

            public String getTable(String tableName) {
                return StringKit.addEscape((String)tableName, (char)'[', (char)']');
            }

            public String getCol(String colName) {
                return StringKit.addEscape((String)colName, (char)'[', (char)']');
            }
        };
        this.sqlServerRange = new SqlServerRange(this);
    }

    public SqlServerStyle(boolean fetchRemark) {
        this();
        this.fetchRemark = fetchRemark;
    }

    @Override
    public MetadataManager initMetadataManager(ConnectionSource cs) {
        this.metadataManager = new MSSqlServerMetadataManager(cs, this, this.fetchRemark);
        return this.metadataManager;
    }

    @Override
    public MetadataManager initMetadataManager(ConnectionSource cs, String defaultSchema, String defalutCatalog) {
        this.metadataManager = new MSSqlServerMetadataManager(cs, defaultSchema, defalutCatalog, this, this.fetchRemark);
        return this.metadataManager;
    }

    @Override
    public String getDefaultSchema() {
        return "dbo";
    }

    @Override
    public String getName() {
        return "sqlserver";
    }

    @Override
    public final int getDBType() {
        return 4;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.sqlServerRange;
    }

    @Override
    public boolean batchGeneratedKeysSupport() {
        return false;
    }

    @Override
    public String getOrderBy() {
        return this.lineSeparator + this.appendExpress("text(' order by ' + _orderBy!'current_timestamp')") + " ";
    }

    static class SqlServerRange
    implements RangeSql {
        SqlServerStyle sqlServerStyle = null;

        public SqlServerRange(SqlServerStyle sqlServerStyle) {
            this.sqlServerStyle = sqlServerStyle;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            offset = PageParamKit.sqlServerOffset(this.sqlServerStyle.offsetStartZero, offset);
            long pageEnd = PageParamKit.sqlServerPageEnd(offset, limit);
            jdbcSql = jdbcSql.replaceFirst("(?is)select(\\s+distinct\\s+)?", "$0 top(" + pageEnd + ") ");
            int capacity = jdbcSql.length() + 190;
            StringBuilder builder = new StringBuilder(capacity);
            builder.append("with query as ( select inner_query.*, row_number() over (order by current_timestamp) as beetl_rn from ( ");
            builder.append(jdbcSql);
            builder.append(" ) inner_query ) select * from query where beetl_rn between ");
            builder.append(offset).append(" and ").append(pageEnd);
            return builder.toString();
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            return "with query as ( select inner_query.*, row_number() over (order by current_timestamp) as beetl_rn from ( " + template.replaceFirst("(?is)select(\\s+distinct\\s+)?", "$0 top(" + this.sqlServerStyle.appendExpress("_pageEnd") + ") ") + this.sqlServerStyle.getOrderBy() + " ) inner_query ) select * from query where beetl_rn between " + this.sqlServerStyle.appendExpress("_pageOffset") + " and " + this.sqlServerStyle.appendExpress("_pageEnd");
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            long s = offset + (long)(this.sqlServerStyle.offsetStartZero ? 1 : 0);
            paras.put("_pageOffset", s);
            paras.put("_pageEnd", s + size - 1L);
        }
    }
}

