/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping;

import java.lang.annotation.Annotation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.ResultSetExt;
import org.beetl.sql.core.mapping.RowMapper;

public class RowMapperResultSetExt<T>
implements ResultSetExt<List<T>> {
    BeanProcessor beanProcessor = null;
    private RowMapper<T> rowMapper;

    public RowMapperResultSetExt(RowMapper<T> _rowMapper, BeanProcessor beanProcessor) {
        this.rowMapper = _rowMapper;
        this.beanProcessor = beanProcessor;
    }

    @Override
    public List<T> handleResultSet(ExecuteContext ctx, ResultSet rs, Class<?> z, Annotation config) throws SQLException {
        int rowNum = 0;
        ArrayList<T> resultList = new ArrayList<T>();
        if (Map.class.isAssignableFrom(z)) {
            while (rs.next()) {
                Map<String, Object> obj = this.beanProcessor.toMap(ctx, z, rs);
                resultList.add(this.rowMapper.mapRow(ctx, obj, rs, rowNum++, config));
            }
        } else if (BeanKit.isBaseDataType(z)) {
            while (rs.next()) {
                Object obj = this.beanProcessor.toBaseType(ctx, z, rs);
                resultList.add(this.rowMapper.mapRow(ctx, obj, rs, rowNum++, config));
            }
        } else {
            while (rs.next()) {
                Object obj = this.beanProcessor.toBean(ctx, rs, z);
                resultList.add(this.rowMapper.mapRow(ctx, obj, rs, rowNum++, config));
            }
        }
        return resultList;
    }
}

