/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.join;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.mapping.join.AttrNode;
import org.beetl.sql.core.mapping.join.JsonConfigMapper;

public class AutoJsonMapper
extends JsonConfigMapper {
    public static int MAX_DEPTH = 4;

    @Override
    protected AttrNode parse(ExecuteContext ctx, Class target, ResultSetMetaData rsmd, Annotation config) throws Exception {
        NameConversion nc = ctx.sqlManager.getNc();
        Map<String, Integer> columnIndex = this.getColumnIndex(rsmd);
        CaseInsensitiveHashMap configMap = new CaseInsensitiveHashMap();
        String prefix = "";
        int level = 0;
        this.getMappingByJson(prefix, nc, (Map<String, Object>)configMap, target, level);
        AttrNode root = new AttrNode(null);
        root.initNode(target, (Map<String, Object>)configMap, columnIndex);
        return root;
    }

    protected void getMappingByJson(String prefix, NameConversion nc, Map<String, Object> configMap, Class target) throws IntrospectionException {
        this.getMappingByJson(prefix, nc, configMap, target, 0);
    }

    protected void getMappingByJson(String prefix, NameConversion nc, Map<String, Object> configMap, Class target, int level) throws IntrospectionException {
        PropertyDescriptor[] pds;
        if (level > MAX_DEPTH) {
            return;
        }
        for (PropertyDescriptor pd : pds = BeanKit.propertyDescriptors((Class)target)) {
            Class<?> type = pd.getPropertyType();
            if (type == Class.class) continue;
            String attr = pd.getName();
            String col = nc.getColName(target, attr);
            String configCol = this.getPrefix(prefix, col);
            if (BeanKit.isBaseDataType(type)) {
                configMap.put(attr, configCol);
                continue;
            }
            Class childType = type;
            if (List.class.isAssignableFrom(type)) {
                Class tempType = BeanKit.getParameterTypeClass((Type)pd.getReadMethod().getGenericReturnType());
                childType = tempType == null ? Map.class : tempType;
            }
            HashMap<String, Object> childConfig = new HashMap<String, Object>();
            this.getMappingByJson(configCol, nc, childConfig, childType, ++level);
            --level;
            configMap.put(attr, childConfig);
        }
    }

    protected String getPrefix(String prefix, String col) {
        if (prefix.length() == 0) {
            return col;
        }
        return prefix + "." + col;
    }
}

