/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.nosql;

import java.util.Map;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class HBaseStyle
extends AbstractDBStyle {
    RangeSql rangeSql = new HbaseRange(this);

    @Override
    public int getIdType(Class c, String idProperty) {
        return 1;
    }

    @Override
    public boolean isNoSql() {
        return true;
    }

    @Override
    public String getName() {
        return "hbase";
    }

    @Override
    public int getDBType() {
        return 106;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.rangeSql;
    }

    @Override
    protected SQLSource generalInsert(Class<?> cls, boolean template) {
        String upsert;
        SQLSource sqlSource = super.generalInsert(cls, template);
        sqlSource.template = upsert = sqlSource.template.replaceFirst("insert", "UPSERT");
        return sqlSource;
    }

    @Override
    public SQLSource genUpdateById(Class<?> cls) {
        return this.generalInsert(cls, false);
    }

    static class HbaseRange
    implements RangeSql {
        AbstractDBStyle sqlStyle = null;

        public HbaseRange(AbstractDBStyle style) {
            this.sqlStyle = style;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            offset = PageParamKit.mysqlOffset(this.sqlStyle.offsetStartZero, offset);
            StringBuilder builder = new StringBuilder(jdbcSql);
            builder.append(" limit ").append(limit).append(" offset ").append(limit);
            return builder.toString();
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            return template + this.sqlStyle.getOrderBy() + " \n limit " + this.sqlStyle.appendExpress("_pageSize") + " \n offset " + this.sqlStyle.appendExpress("_pageOffset");
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            paras.put("_pageOffset", offset - (long)(this.sqlStyle.offsetStartZero ? 0 : 1));
            paras.put("_pageSize", size);
        }
    }
}

