/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.nosql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.range.RangeSql;

public class HiveStyle
extends AbstractDBStyle {
    RangeSql rangeSql = new HiveRange(this);

    @Override
    public int getIdType(Class c, String idProperty) {
        return 1;
    }

    @Override
    public boolean isNoSql() {
        return true;
    }

    @Override
    public String getName() {
        return "hive";
    }

    @Override
    public int getDBType() {
        return 107;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.rangeSql;
    }

    @Override
    public void config(SQLManager sqlManager) {
        sqlManager.setDefaultBeanProcessors(new BeanProcessor(){

            @Override
            protected String getColName(ExecuteContext ctx, ResultSetMetaData rsmd, int col) throws SQLException {
                String colName = super.getColName(ctx, rsmd, col);
                if (ctx.sqlId.isPage()) {
                    colName = colName.replaceFirst(HiveRange.pagePrefix + ".", "");
                }
                return colName;
            }
        });
    }

    static class HiveRange
    implements RangeSql {
        AbstractDBStyle sqlStyle = null;
        static String pagePrefix = "page_";
        String jdbcPageTemplate = "select * from \n        (\n        SELECT ccc.*,ROW_NUMBER() over (Order by ccc.id) as rowid FROM ({0}) ccc \n        ) " + pagePrefix + " \n    where rowid > {1} and rowid <={2}";

        public HiveRange(AbstractDBStyle style) {
            this.sqlStyle = style;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            offset = PageParamKit.mysqlOffset(this.sqlStyle.offsetStartZero, offset);
            String sql = MessageFormat.format(this.jdbcPageTemplate, jdbcSql, offset, limit + offset);
            return sql;
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            String orderBySql = template + this.sqlStyle.getOrderBy();
            String sql = MessageFormat.format(this.jdbcPageTemplate, orderBySql, this.sqlStyle.appendExpress("_pageOffset"), this.sqlStyle.appendExpress("_pageSize"));
            return sql;
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            offset = PageParamKit.mysqlOffset(this.sqlStyle.offsetStartZero, offset);
            paras.put("_pageOffset", offset);
            paras.put("_pageSize", offset + size);
        }
    }
}

