/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.query;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.page.PageResult;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.core.query.QueryCondition;
import org.beetl.sql.core.query.interfacer.StrongValue;

public class LambdaQuery<T>
extends Query<T> {
    public LambdaQuery(SQLManager sqlManager, Class clazz) {
        super(sqlManager, clazz);
    }

    @Override
    public List<T> select() {
        return super.select();
    }

    public List<T> select(Property<T, ?> ... cols) {
        String[] colArray = this.getColumnNames(cols);
        return super.select(colArray);
    }

    public PageResult<T> page(long pageNumber, long pageSize) {
        return super.page(pageNumber, pageSize, new String[0]);
    }

    public PageResult<T> page(long pageNumber, long pageSize, Property<T, ?> ... cols) {
        String[] colArray = this.getColumnNames(cols);
        return super.page(pageNumber, pageSize, colArray);
    }

    public LambdaQuery<T> andEq(Property<T, ?> property, Object value) {
        super.andEq(this.getColumnName(property), value);
        return this;
    }

    public LambdaQuery<T> andNotEq(Property<T, ?> property, Object value) {
        super.andNotEq(this.getColumnName(property), value);
        return this;
    }

    public LambdaQuery<T> andGreat(Property<T, ?> property, Object value) {
        super.appendAndSql(this.getColumnName(property), value, ">");
        return this;
    }

    public LambdaQuery<T> andGreatEq(Property<T, ?> property, Object value) {
        this.appendAndSql(this.getColumnName(property), value, ">=");
        return this;
    }

    public LambdaQuery<T> andLess(Property<T, ?> property, Object value) {
        this.appendAndSql(this.getColumnName(property), value, "<");
        return this;
    }

    public LambdaQuery<T> andLessEq(Property<T, ?> property, Object value) {
        this.appendAndSql(this.getColumnName(property), value, "<=");
        return this;
    }

    public LambdaQuery<T> andLike(Property<T, ?> property, Object value) {
        this.appendAndSql(this.getColumnName(property), value, "LIKE ");
        return this;
    }

    public LambdaQuery<T> andNotLike(Property<T, ?> property, Object value) {
        this.appendAndSql(this.getColumnName(property), value, "NOT LIKE ");
        return this;
    }

    public LambdaQuery<T> andIsNull(Property<T, ?> property) {
        this.appendAndSql(this.getColumnName(property), null, "IS NULL ");
        return this;
    }

    public LambdaQuery<T> andIsNotNull(Property<T, ?> property) {
        this.appendAndSql(this.getColumnName(property), null, "IS NOT NULL ");
        return this;
    }

    public LambdaQuery<T> andIn(Property<T, ?> property, Collection<?> value) {
        this.appendInSql(this.getColumnName(property), value, "IN", "AND");
        return this;
    }

    public LambdaQuery<T> andNotIn(Property<T, ?> property, Collection<?> value) {
        this.appendInSql(this.getColumnName(property), value, "NOT IN", "AND");
        return this;
    }

    public LambdaQuery<T> andIn(Property<T, ?> property, StrongValue value) {
        this.appendInSql(this.getColumnName(property), value, "IN", "AND");
        return this;
    }

    public LambdaQuery<T> andNotIn(Property<T, ?> property, StrongValue value) {
        this.appendInSql(this.getColumnName(property), value, "NOT IN", "AND");
        return this;
    }

    public LambdaQuery<T> andBetween(Property<T, ?> property, Object value1, Object value2) {
        this.appendBetweenSql(this.getColumnName(property), "BETWEEN", "AND", value1, value2);
        return this;
    }

    public LambdaQuery<T> andNotBetween(Property<T, ?> property, Object value1, Object value2) {
        this.appendBetweenSql(this.getColumnName(property), "NOT BETWEEN", "AND", value1, value2);
        return this;
    }

    public LambdaQuery<T> orEq(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, "=");
        return this;
    }

    public LambdaQuery<T> orNotEq(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, "<>");
        return this;
    }

    public LambdaQuery<T> orGreat(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, ">");
        return this;
    }

    public LambdaQuery<T> orGreatEq(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, ">=");
        return this;
    }

    public LambdaQuery<T> orLess(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, "<");
        return this;
    }

    public LambdaQuery<T> orLessEq(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, "<=");
        return this;
    }

    public LambdaQuery<T> orLike(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, "LIKE ");
        return this;
    }

    public LambdaQuery<T> orNotLike(Property<T, ?> property, Object value) {
        this.appendOrSql(this.getColumnName(property), value, "NOT LIKE ");
        return this;
    }

    public LambdaQuery<T> orIsNull(Property<T, ?> property) {
        this.appendOrSql(this.getColumnName(property), null, "IS NULL ");
        return this;
    }

    public LambdaQuery<T> orIsNotNull(Property<T, ?> property) {
        this.appendOrSql(this.getColumnName(property), null, "IS NOT NULL ");
        return this;
    }

    public LambdaQuery<T> orIn(Property<T, ?> property, Collection<?> value) {
        this.appendInSql(this.getColumnName(property), value, "IN", "OR");
        return this;
    }

    public LambdaQuery<T> orIn(Property<T, ?> property, StrongValue value) {
        this.appendInSql(this.getColumnName(property), value, "IN", "OR");
        return this;
    }

    public LambdaQuery<T> orIn(Property<T, ?> property, Optional value) {
        this.appendInSql(this.getColumnName(property), value, "IN", "OR");
        return this;
    }

    public LambdaQuery<T> orNotIn(Property<T, ?> property, Collection<?> value) {
        this.appendInSql(this.getColumnName(property), value, "NOT IN", "OR");
        return this;
    }

    public LambdaQuery<T> orNotIn(Property<T, ?> property, StrongValue value) {
        this.appendInSql(this.getColumnName(property), value, "NOT IN", "OR");
        return this;
    }

    public LambdaQuery<T> orNotIn(Property<T, ?> property, Optional value) {
        this.appendInSql(this.getColumnName(property), value, "NOT IN", "OR");
        return this;
    }

    public LambdaQuery<T> orBetween(Property<T, ?> property, Object value1, Object value2) {
        this.appendBetweenSql(this.getColumnName(property), "BETWEEN", "OR", value1, value2);
        return this;
    }

    public LambdaQuery<T> orNotBetween(Property<T, ?> property, Object value1, Object value2) {
        this.appendBetweenSql(this.getColumnName(property), "NOT BETWEEN", "OR", value1, value2);
        return this;
    }

    public LambdaQuery<T> groupBy(Property<T, ?> property) {
        super.groupBy(this.getColumnName(property));
        return this;
    }

    public LambdaQuery<T> orderBy(Property<T, ?> property) {
        super.orderBy(this.getColumnName(property));
        return this;
    }

    public LambdaQuery<T> asc(Property<T, ?> property) {
        super.asc(this.getColumnName(property));
        return this;
    }

    public LambdaQuery<T> desc(Property<T, ?> property) {
        super.desc(this.getColumnName(property));
        return this;
    }

    public String getColumnName(Property<T, ?> property) {
        try {
            Method declaredMethod = property.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            declaredMethod.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)declaredMethod.invoke(property, new Object[0]);
            String method = serializedLambda.getImplMethodName();
            String attr = null;
            attr = method.startsWith("get") ? method.substring(3) : method.substring(2);
            return this.sqlManager.getNc().getColName(this.clazz, StringKit.toLowerCaseFirstOne((String)attr));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Class getColumnType(Property<T, ?> property) {
        try {
            Method declaredMethod = property.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            declaredMethod.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)declaredMethod.invoke(property, new Object[0]);
            String method = serializedLambda.getImplMethodName();
            Class<?> type = this.clazz.getMethod(method, new Class[0]).getReturnType();
            return type;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getColumnNames(Property<T, ?> ... properties) {
        String[] cols = new String[properties.length];
        int i = 0;
        for (Property<T, ?> property : properties) {
            cols[i++] = this.getColumnName(property);
        }
        return cols;
    }

    @Override
    public LambdaQuery<T> condition() {
        return new LambdaQuery<T>(this.sqlManager, this.clazz);
    }

    @Override
    public LambdaQuery<T> and(QueryCondition condition) {
        super.and(condition);
        return this;
    }

    @Override
    public LambdaQuery<T> asTable(String tableName) {
        super.asTable(tableName);
        return this;
    }

    @Override
    public LambdaQuery<T> virtualTable() {
        super.virtualTable();
        return this;
    }

    @Override
    public LambdaQuery<T> or(QueryCondition condition) {
        super.or(condition);
        return this;
    }

    @Override
    public LambdaQuery<T> having(QueryCondition condition) {
        super.having(condition);
        return this;
    }

    @Override
    public LambdaQuery<T> limit(Object startRow, long pageSize) {
        super.limit(startRow, pageSize);
        return this;
    }

    @Override
    public LambdaQuery<T> addParam(Collection<?> objects) {
        super.addParam(objects);
        return this;
    }

    @Override
    public LambdaQuery<T> appendSql(String sqlPart) {
        super.appendSql(sqlPart);
        return this;
    }

    @Override
    public void addPreParam(List<Object> objects) {
        super.addPreParam(objects);
    }

    @Override
    public LambdaQuery<T> addParam(Object object) {
        super.addParam(object);
        return this;
    }

    @Override
    public LambdaQuery<T> groupBy(String column) {
        super.groupBy(column);
        return this;
    }

    @Override
    public LambdaQuery<T> orderBy(String orderBy) {
        super.orderBy(orderBy);
        return this;
    }

    @Override
    public LambdaQuery<T> asc(String column) {
        super.asc(column);
        return this;
    }

    @Override
    public LambdaQuery<T> desc(String column) {
        super.desc(column);
        return this;
    }

    @Override
    public LambdaQuery<T> andEq(String column, Object value) {
        super.andEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andNotEq(String column, Object value) {
        super.andNotEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andGreat(String column, Object value) {
        super.andGreat(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andGreatEq(String column, Object value) {
        super.andGreatEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andLess(String column, Object value) {
        super.andLess(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andLessEq(String column, Object value) {
        super.andLessEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andLike(String column, Object value) {
        super.andLike(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andNotLike(String column, Object value) {
        super.andNotLike(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andIsNull(String column) {
        super.andIsNull(column);
        return this;
    }

    @Override
    public LambdaQuery<T> andIsNotNull(String column) {
        super.andIsNotNull(column);
        return this;
    }

    @Override
    public LambdaQuery<T> andIn(String column, Collection<?> value) {
        super.andIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andIn(String column, StrongValue value) {
        super.andIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andNotIn(String column, Collection<?> value) {
        super.andNotIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andNotIn(String column, StrongValue value) {
        super.andNotIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> andBetween(String column, Object value1, Object value2) {
        super.andBetween(column, value1, value2);
        return this;
    }

    @Override
    public LambdaQuery<T> andNotBetween(String column, Object value1, Object value2) {
        super.andNotBetween(column, value1, value2);
        return this;
    }

    @Override
    public LambdaQuery<T> orEq(String column, Object value) {
        super.orEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orNotEq(String column, Object value) {
        super.orNotEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orGreat(String column, Object value) {
        super.orGreat(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orGreatEq(String column, Object value) {
        super.orGreatEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orLess(String column, Object value) {
        super.orLess(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orLessEq(String column, Object value) {
        super.orLessEq(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orLike(String column, Object value) {
        super.orLike(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orNotLike(String column, Object value) {
        super.orNotLike(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orIsNull(String column) {
        super.orIsNull(column);
        return this;
    }

    @Override
    public LambdaQuery<T> orIsNotNull(String column) {
        super.orIsNotNull(column);
        return this;
    }

    @Override
    public LambdaQuery<T> orIn(String column, Collection<?> value) {
        super.orIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orIn(String column, StrongValue value) {
        super.orIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orNotIn(String column, Collection<?> value) {
        super.orNotIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orNotIn(String column, StrongValue value) {
        super.orNotIn(column, value);
        return this;
    }

    @Override
    public LambdaQuery<T> orBetween(String column, Object value1, Object value2) {
        super.orBetween(column, value1, value2);
        return this;
    }

    @Override
    public LambdaQuery<T> orNotBetween(String column, Object value1, Object value2) {
        super.orNotBetween(column, value1, value2);
        return this;
    }

    @Override
    public LambdaQuery<T> useCondition(QueryCondition condition) {
        super.useCondition(condition);
        return this;
    }

    public static interface Property<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

