/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.range;

import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class RowNumRange
implements RangeSql {
    AbstractDBStyle dbStyle = null;

    public RowNumRange(AbstractDBStyle dbStyle) {
        this.dbStyle = dbStyle;
    }

    @Override
    public String toRange(String jdbcSql, Object objOffset, Long limit) {
        Long offset = ((Number)objOffset).longValue();
        offset = PageParamKit.oracleOffset(this.dbStyle.offsetStartZero, offset);
        long pageEnd = PageParamKit.oraclePageEnd(offset, limit);
        int capacity = jdbcSql.length() + 133;
        StringBuilder builder = new StringBuilder(capacity);
        builder.append("SELECT * FROM ");
        builder.append(" ( ");
        builder.append(" SELECT beeltT.*, ROWNUM beetl_rn ");
        builder.append(" FROM ( \n").append(jdbcSql).append("\n )  beeltT ");
        builder.append(" WHERE ROWNUM < ").append(pageEnd);
        builder.append(" ) ");
        builder.append("WHERE beetl_rn >= ").append(offset);
        return builder.toString();
    }

    @Override
    public String toTemplateRange(Class mapping, String template) {
        String pageSql = "SELECT * FROM  (  SELECT beeltT.*, ROWNUM beetl_rn  FROM ( \n" + template + this.dbStyle.getOrderBy() + "\n )  beeltT  WHERE ROWNUM <" + this.dbStyle.appendExpress("_pageEnd") + ") WHERE beetl_rn >= " + this.dbStyle.appendExpress("_pageOffset");
        return pageSql;
    }

    @Override
    public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
        Long offset = (Long)objOffset;
        long s = offset + (long)(this.dbStyle.offsetStartZero ? 1 : 0);
        paras.put("_pageOffset", s);
        paras.put("_pageEnd", s + size);
    }
}

