/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.annotation.builder;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.ExecuteContext;

public class Date2LongConvert
implements AttributeConvert {
    @Override
    public Object toDb(ExecuteContext ctx, Class cls, String name, Object pojo) {
        Object value = BeanKit.getBeanProperty((Object)pojo, (String)name);
        if (value == null) {
            return null;
        }
        Long time = 0L;
        if (value instanceof Date) {
            time = ((Date)value).getTime();
        } else if (value instanceof Timestamp) {
            time = ((Timestamp)value).getTime();
        } else {
            throw new UnsupportedOperationException("@Date2Long \u4e0d\u652f\u6301\u7684\u7c7b\u578b " + value.getClass() + ",\u671f\u671b\u662f Date\u6216\u8005Timestamp");
        }
        return time;
    }

    @Override
    public Object toAttr(ExecuteContext ctx, Class cls, String name, ResultSet rs, int index) throws SQLException {
        Class<?> type = BeanKit.getPropertyDescriptor((Class)cls, (String)name).getPropertyType();
        Long time = rs.getLong(index);
        if (time == null) {
            return null;
        }
        if (type == Date.class) {
            return new Date(time);
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(time);
        }
        if (type == Timestamp.class) {
            return new Timestamp(time);
        }
        throw new UnsupportedOperationException("@Date2Long \u4e0d\u652f\u6301\u7684\u7c7b\u578b " + type + ",\u671f\u671b\u662f Date\u6216\u8005Timestamp");
    }
}

