/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.loader.AbstractSQLLoader;
import org.beetl.sql.core.loader.SQLFileParser;
import org.beetl.sql.core.loader.SQLFileVersion;

public abstract class PathLoader
extends AbstractSQLLoader {
    protected String sqlRoot;
    protected String charset;
    protected SQLSource EMPTY = SQLSource.emptySource();

    public PathLoader(String root, String charset) {
        this.sqlRoot = root;
        this.charset = charset;
    }

    public PathLoader(String root) {
        this.sqlRoot = root;
        this.charset = Charset.defaultCharset().name();
    }

    public PathLoader() {
        this("sql");
    }

    @Override
    public SQLSource loadSQL(SqlId id) {
        if (this.autoGenSourceMap.containsKey(id)) {
            return (SQLSource)this.autoGenSourceMap.get(id);
        }
        this.loadFromClassPath(id);
        SQLSource source = this.sqlSourceMap.computeIfAbsent(id, key -> this.EMPTY);
        if (source == this.EMPTY) {
            return null;
        }
        return source;
    }

    @Override
    public SQLSource queryExternalSource(SqlId id) {
        if (this.isProduct()) {
            SQLSource source = (SQLSource)this.sqlSourceMap.get(id);
            if (source == this.EMPTY) {
                return null;
            }
            if (source != null) {
                return source;
            }
            return this.loadSQL(id);
        }
        if (this.isExternalSourceModified4Load(id)) {
            return this.loadSQL(id);
        }
        return this.queryFromCache(id);
    }

    protected SQLSource queryFromCache(SqlId sqlId) {
        SQLSource source = (SQLSource)this.sqlSourceMap.get(sqlId);
        if (source == this.EMPTY) {
            return null;
        }
        return source;
    }

    protected boolean isExternalSourceModified4Load(SqlId id) {
        SQLSource source = (SQLSource)this.sqlSourceMap.get(id);
        if (source == null) {
            return true;
        }
        long oldRootVersion = source.getVersion().root;
        long oldDbVersion = source.getVersion().db;
        if (oldDbVersion != 0L) {
            URL db = this.getDBRootFile(id);
            return this.getURLVersion(db) != oldDbVersion;
        }
        if (oldRootVersion != 0L) {
            URL root = this.getRootFile(id);
            return this.getURLVersion(root) != oldRootVersion;
        }
        return false;
    }

    @Override
    public boolean existExternalSource(SqlId id) {
        SQLSource source = this.queryExternalSource(id);
        return source != null;
    }

    protected Long getURLVersion(URL url) {
        if (url == null) {
            return 0L;
        }
        if ("file".equals(url.getProtocol())) {
            String path = url.getFile();
            return new File(path).lastModified();
        }
        return 0L;
    }

    protected void loadFromClassPath(SqlId id) {
        URL ins = this.getRootFile(id);
        this.readSqlFile(id, ins, true);
        ins = this.getDBRootFile(id);
        this.readSqlFile(id, ins, false);
    }

    protected void readSqlFile(SqlId sqlId, URL url, boolean isRoot) {
        InputStream ins;
        if (url == null) {
            return;
        }
        try {
            ins = url.openStream();
        }
        catch (IOException e1) {
            return;
        }
        String modelName = sqlId.getNamespace();
        long lastModified = this.getURLVersion(url);
        BufferedReader bf = null;
        try {
            bf = this.buildBufferedReader(ins, this.charset);
            SQLFileParser parser = this.getParser(modelName, bf);
            SQLSource source = null;
            while ((source = parser.next()) != null) {
                source.sqlType = SQLType.UNKNOWN;
                SQLFileVersion version = new SQLFileVersion();
                version.url = url;
                if (isRoot) {
                    version.root = lastModified;
                } else {
                    version.db = lastModified;
                }
                source.setVersion(version);
                this.sqlSourceMap.put(source.getId(), source);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected URL getRootFile(SqlId id) {
        URL url = this.getFilePath(this.sqlRoot, id);
        return url;
    }

    protected URL getDBRootFile(SqlId id) {
        String root = this.sqlRoot + "/" + this.dbs.getName();
        URL url = this.getFilePath(root, id);
        return url;
    }

    protected URL getFilePath(String root, SqlId id) {
        String path = this.getPathBySqlId(id);
        String filePath0 = root + "/" + path + ".sql";
        String filePath1 = root + "/" + path + ".md";
        URL is = this.getFile(filePath0);
        if (is == null) {
            is = this.getFile(filePath1);
        }
        return is;
    }

    protected abstract URL getFile(String var1);

    public String toString() {
        return this.sqlRoot;
    }

    @Override
    public boolean existNamespace(SqlId id) {
        URL root = this.getRootFile(id);
        if (root != null) {
            return true;
        }
        URL db = this.getDBRootFile(id);
        return db != null;
    }

    protected abstract SQLFileParser getParser(String var1, BufferedReader var2) throws IOException;

    protected BufferedReader buildBufferedReader(InputStream inputStream, String charset) {
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream, charset));
            return bf;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684charset " + charset);
        }
    }

    public String getSqlRoot() {
        return this.sqlRoot;
    }

    public void setSqlRoot(String sqlRoot) {
        this.sqlRoot = sqlRoot;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.sqlSourceMap.clear();
    }
}

