/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.beetl.core.fun.MethodInvoker;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.query.LambdaQuery;

public class OrderByBuilder {
    SQLManager sqlManager = null;
    StringBuilder sb = new StringBuilder();

    public OrderByBuilder(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    static OrderByBuilder from(SQLManager sqlManager) {
        return new OrderByBuilder(sqlManager);
    }

    public OrderByBuilder asc(Class clz, String name) {
        this.checkProperty(clz, name);
        this.sb.append(name + " asc ");
        return this;
    }

    public OrderByBuilder asc(Class clz, String name, String prefix) {
        this.checkProperty(clz, name);
        this.sb.append(prefix + "." + name + " asc ");
        return this;
    }

    public OrderByBuilder asc(Function name) {
        return this;
    }

    public OrderByBuilder asc(LambdaQuery.Property name, String prefix) {
        return this;
    }

    public OrderByBuilder desc(String name) {
        return this;
    }

    protected String getFunctionName(LambdaQuery.Property property) {
        try {
            Method declaredMethod = property.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            declaredMethod.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)declaredMethod.invoke((Object)property, new Object[0]);
            String method = serializedLambda.getImplMethodName();
            String attr = null;
            attr = method.startsWith("get") ? method.substring(3) : method.substring(2);
            String cls = serializedLambda.getImplClass();
            Class<?> clazz = Class.forName(cls.replace('/', '.'));
            return this.sqlManager.getNc().getColName(clazz, StringKit.toLowerCaseFirstOne((String)attr));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkProperty(Class clz, String name) {
        MethodInvoker inv = ObjectUtil.getInvokder((Class)clz, (String)name);
        if (inv == null) {
            throw new IllegalArgumentException("\u5c5e\u6027\u4e0d\u5b58\u5728 " + clz + "." + name);
        }
    }

    public static void main(String[] args) {
        new OrderByBuilder(null).test();
    }

    public void test() {
    }

    public static class User {
        String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "OrderByBuilder.User(name=" + this.getName() + ")";
        }
    }
}

