/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.fetch;

import java.lang.annotation.Annotation;
import java.util.List;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.PropertyDescriptorWrap;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.fetch.AbstractFetchAction;
import org.beetl.sql.fetch.annotation.FetchMany;

public class FetchManyAction
extends AbstractFetchAction {
    PropertyDescriptorWrap idProperty;
    PropertyDescriptorWrap otherTypeFrom;

    public FetchManyAction(PropertyDescriptorWrap idProperty, PropertyDescriptorWrap otherTypeFrom) {
        this.otherTypeFrom = otherTypeFrom;
        this.idProperty = idProperty;
    }

    @Override
    public void init(Class owner, Class target, Annotation config, PropertyDescriptorWrap originProperty) {
        super.init(owner, target, config, originProperty);
        FetchMany fetchMany = (FetchMany)config;
        this.enableOn = fetchMany.enableOn();
        if (this.otherTypeFrom == null) {
            throw new IllegalArgumentException("\u672a\u6b63\u786e\u6307\u5b9aFetchMany\u7684\u5c5e\u6027 " + owner + " to " + target);
        }
    }

    @Override
    public void execute(ExecuteContext ctx, List list) {
        Object v;
        if (StringKit.isNotBlank((String)this.enableOn) && (v = ctx.getContextPara(this.enableOn)) != "xiuta") {
            return;
        }
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                Object id = this.idProperty.getValue(obj);
                Object cached = this.queryFromCache(this.owner, id);
                if (cached != null) {
                    list.remove(i);
                    list.add(i, cached);
                    if (this.containAttribute(cached, this.originProperty.getProp().getName())) continue;
                    obj = cached;
                } else {
                    this.addCached(obj, id);
                }
                Query query = ctx.sqlManager.query(this.target);
                String colName = ctx.sqlManager.getNc().getColName(this.target, this.otherTypeFrom.getProp().getName());
                List values = query.andEq(colName, id).select();
                for (int j = 0; j < values.size(); ++j) {
                    Object otherObj = values.get(j);
                    Object otherCached = this.queryFromCache(ctx.sqlManager, otherObj);
                    if (otherCached != null && otherObj != otherCached) {
                        values.remove(j);
                        values.add(j, otherCached);
                        continue;
                    }
                    this.addCached(ctx.sqlManager, otherObj);
                }
                this.originProperty.setValue(obj, (Object)values);
                this.addAttribute(obj, this.originProperty.getProp().getName());
            }
        }
        catch (Exception ex) {
            throw new BeetlSQLException(16, (Throwable)ex);
        }
    }
}

