/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.builder;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.mapper.BaseMapper;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.annotation.AutoMapper;
import org.beetl.sql.mapper.builder.MapperConfigBuilder;
import org.beetl.sql.mapper.builder.MapperMethodParser;

public class BaseMapperConfigBuilder
implements MapperConfigBuilder {
    protected final Map<Method, MapperInvoke> amiMethodMap = new ConcurrentHashMap<Method, MapperInvoke>();

    public BaseMapperConfigBuilder() {
        this.init();
    }

    @Override
    public MapperInvoke getAmi(Class entity, Class mapperClass, Method method) {
        MapperInvoke mapperInvoke = this.amiMethodMap.get(method);
        if (mapperInvoke != null) {
            return mapperInvoke;
        }
        MapperMethodParser mapperMethodParser = new MapperMethodParser(entity, mapperClass, method);
        mapperInvoke = mapperMethodParser.parse();
        mapperInvoke = this.wrap(mapperInvoke, method);
        this.amiMethodMap.putIfAbsent(method, mapperInvoke);
        return mapperInvoke;
    }

    protected void init() {
        this.addMapperClass(BaseMapper.class);
    }

    @Override
    public void addMapperClass(Class c) {
        this.scanBaseMapper(c);
    }

    protected void scanBaseMapper(Class c) {
        Method[] methods;
        HashMap<Method, MapperInvoke> map = new HashMap<Method, MapperInvoke>();
        for (Method method : methods = c.getMethods()) {
            AutoMapper autoMapper = method.getAnnotation(AutoMapper.class);
            if (autoMapper == null) continue;
            Class<? extends MapperInvoke> mapperClass = autoMapper.value();
            MapperInvoke ins = (MapperInvoke)BeanKit.newSingleInstance(mapperClass);
            map.put(method, this.wrap(ins, method));
        }
        if (map.isEmpty()) {
            return;
        }
        this.amiMethodMap.putAll(map);
    }

    protected MapperInvoke wrap(MapperInvoke old, Method method) {
        return old;
    }
}

