/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper;

import java.util.List;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.mapper.annotation.AutoMapper;
import org.beetl.sql.mapper.internal.AllAMI;
import org.beetl.sql.mapper.internal.AllCountAMI;
import org.beetl.sql.mapper.internal.DeleteByIdAMI;
import org.beetl.sql.mapper.internal.ExecuteAMI;
import org.beetl.sql.mapper.internal.ExecuteUpdateAMI;
import org.beetl.sql.mapper.internal.GetSQLManagerAMI;
import org.beetl.sql.mapper.internal.GetTargetEntityAMI;
import org.beetl.sql.mapper.internal.InsertAMI;
import org.beetl.sql.mapper.internal.InsertBatchAMI;
import org.beetl.sql.mapper.internal.InsertTemplateAMI;
import org.beetl.sql.mapper.internal.LambdaQueryAMI;
import org.beetl.sql.mapper.internal.LockAMI;
import org.beetl.sql.mapper.internal.QueryAMI;
import org.beetl.sql.mapper.internal.SelectByIdsAMI;
import org.beetl.sql.mapper.internal.SingleAMI;
import org.beetl.sql.mapper.internal.TemplateAMI;
import org.beetl.sql.mapper.internal.TemplateCountAMI;
import org.beetl.sql.mapper.internal.TemplateOneAMI;
import org.beetl.sql.mapper.internal.UniqueAMI;
import org.beetl.sql.mapper.internal.UpdateByIdAMI;
import org.beetl.sql.mapper.internal.UpdateTemplateByIdAMI;
import org.beetl.sql.mapper.internal.UpsertAMI;
import org.beetl.sql.mapper.internal.UpsertByTemplateAMI;

public interface BaseMapper<T> {
    @AutoMapper(value=InsertAMI.class)
    public void insert(T var1);

    @AutoMapper(value=InsertTemplateAMI.class)
    public void insertTemplate(T var1);

    @AutoMapper(value=InsertBatchAMI.class)
    public void insertBatch(List<T> var1);

    @AutoMapper(value=UpdateByIdAMI.class)
    public int updateById(T var1);

    @AutoMapper(value=UpdateTemplateByIdAMI.class)
    public int updateTemplateById(T var1);

    @AutoMapper(value=UpsertAMI.class)
    public boolean upsert(T var1);

    @AutoMapper(value=UpsertByTemplateAMI.class)
    public boolean upsertByTemplate(T var1);

    @AutoMapper(value=DeleteByIdAMI.class)
    public int deleteById(Object var1);

    @AutoMapper(value=UniqueAMI.class)
    public T unique(Object var1);

    @AutoMapper(value=SingleAMI.class)
    public T single(Object var1);

    @AutoMapper(value=SelectByIdsAMI.class)
    public List<T> selectByIds(List<?> var1);

    default public boolean exist(Object key) {
        return this.getSQLManager().exist(this.getTargetEntity(), key);
    }

    @AutoMapper(value=LockAMI.class)
    public T lock(Object var1);

    @AutoMapper(value=AllAMI.class)
    public List<T> all();

    @AutoMapper(value=AllCountAMI.class)
    public long allCount();

    @AutoMapper(value=TemplateAMI.class)
    public List<T> template(T var1);

    @AutoMapper(value=TemplateOneAMI.class)
    public <T> T templateOne(T var1);

    @AutoMapper(value=TemplateCountAMI.class)
    public long templateCount(T var1);

    @AutoMapper(value=ExecuteAMI.class)
    public List<T> execute(String var1, Object ... var2);

    @AutoMapper(value=ExecuteUpdateAMI.class)
    public int executeUpdate(String var1, Object ... var2);

    @AutoMapper(value=GetSQLManagerAMI.class)
    public SQLManager getSQLManager();

    @AutoMapper(value=QueryAMI.class)
    public Query<T> createQuery();

    @AutoMapper(value=LambdaQueryAMI.class)
    public LambdaQuery<T> createLambdaQuery();

    @AutoMapper(value=GetTargetEntityAMI.class)
    public Class getTargetEntity();
}

