/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.builder;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.page.PageResult;

public class ReturnTypeParser {
    Method method;
    Type type;
    Class target;
    Class defaultRetType;

    public ReturnTypeParser(Method method, Class defaultRetType) {
        this.method = method;
        this.type = method.getGenericReturnType();
        this.target = method.getReturnType();
        this.defaultRetType = defaultRetType;
    }

    public Class getType() {
        return this.target;
    }

    public boolean isPageResult() {
        return PageResult.class.isAssignableFrom(this.target);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.target);
    }

    public Class getCollectionType() {
        Class collectionType = BeanKit.getCollectionType((Type)this.type);
        if (collectionType == null) {
            return this.defaultRetType;
        }
        return collectionType;
    }

    public Class getPageResultType() {
        if (!(this.type instanceof ParameterizedType)) {
            return this.defaultRetType;
        }
        Class paraType = BeanKit.getParameterTypeClass((Type)this.type);
        return paraType == null ? this.defaultRetType : paraType;
    }
}

