/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.beetl.core.util.ArrayUtils;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.ListUtil;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.mapper.MapperInvoke;

public class ClearFieldsByIdsAMI
extends MapperInvoke {
    @Override
    public Object call(SQLManager sm, Class entityClass, Method m, Object[] args) {
        if (!(args[0] instanceof List)) {
            throw new BeetlSQLException(3, "\u671f\u671b\u7b2c\u4e00\u4e2a\u53c2\u6570\u662fList");
        }
        List pks = (List)args[0];
        Object[] props = (LambdaQuery.Property[])args[1];
        if (ListUtil.isEmpty((Collection)pks) || ArrayUtils.isEmpty((Object[])props)) {
            throw new BeetlSQLException(3, "\u4e3b\u952e\u6216\u8981\u6e05\u7a7a\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tableName = sm.getNc().getTableName(entityClass);
        if (StringKit.isEmpty((String)tableName)) {
            throw new BeetlSQLException(3, "\u6839\u636eClass\u627e\u4e0d\u5230\u6620\u5c04\u7684\u6570\u636e\u5e93\u8868");
        }
        LambdaQuery lambdaQuery = sm.lambdaQuery(entityClass);
        String[] cols = new String[props.length];
        for (int i = 0; i < props.length; ++i) {
            cols[i] = lambdaQuery.getColumnName((LambdaQuery.Property)props[i]);
        }
        List batchPks = ListUtil.partition((List)pks, (int)2000);
        batchPks.forEach(ids -> this.clearTableCols(sm, entityClass, tableName, cols, (List<Object>)ids));
        return pks.size();
    }

    private boolean isLegalColumn(Set<String> cols, String col) {
        for (String column : cols) {
            if (!column.equalsIgnoreCase(col)) continue;
            return true;
        }
        return false;
    }

    private void clearTableCols(SQLManager sm, Class entityClass, String tableName, String[] columns, List<Object> pks) {
        TableDesc tableDesc = sm.getMetaDataManager().getTable(tableName);
        Set pkNames = tableDesc.getIdNames();
        if (ListUtil.isEmpty((Collection)pkNames) || pkNames.size() != 1) {
            throw new BeetlSQLException(3, "\u8868" + tableName + "\u6ca1\u6709\u4e3b\u952e\u6216\u4e3a\u590d\u5408\u4e3b\u952e\uff0c\u4e0d\u652f\u6301\u6e05\u7a7a\u5b57\u6bb5\u64cd\u4f5c");
        }
        LambdaQuery query = sm.lambdaQuery(entityClass);
        query.andIn((String)pkNames.iterator().next(), pks);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName.toUpperCase()).append(" SET ");
        List col = ListUtil.newArrayList();
        for (String column : columns) {
            if (!this.isLegalColumn(tableDesc.getCols(), column)) continue;
            column = column + "=NULL";
            column = column.toUpperCase();
            col.add(column);
        }
        if (ListUtil.isEmpty((Collection)col)) {
            throw new BeetlSQLException(3, "\u4f20\u5165\u7684\u8868\u5217\u540d\u4e0d\u5408\u6cd5");
        }
        sql.append(StringKit.join(col.iterator(), (String)",")).append(" ");
        sql.append((CharSequence)query.getSql());
        SQLReady sqlReady = new SQLReady(sql.toString(), pks.toArray());
        sm.executeUpdate(sqlReady);
    }
}

