/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.ClassLoaderKit;
import org.beetl.sql.core.MapperBuilder;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.mapper.MapperJava8Proxy;
import org.beetl.sql.mapper.MapperJavaProxy;
import org.beetl.sql.mapper.builder.BaseMapperConfigBuilder;
import org.beetl.sql.mapper.builder.MapperConfigBuilder;

public class DefaultMapperBuilder
implements MapperBuilder {
    protected Map<Class<?>, Object> cache = new ConcurrentHashMap();
    protected SQLManager sqlManager;
    protected MapperConfigBuilder mapperConfig = new BaseMapperConfigBuilder();

    public DefaultMapperBuilder() {
    }

    public DefaultMapperBuilder(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public <T> T getMapper(Class<T> mapperInterface) {
        if (this.sqlManager == null) {
            throw new IllegalStateException("SQLManager is null");
        }
        if (this.cache.containsKey(mapperInterface)) {
            return (T)this.cache.get(mapperInterface);
        }
        T instance = this.buildInstance(mapperInterface);
        this.cache.put(mapperInterface, instance);
        return instance;
    }

    public <T> T buildInstance(Class<T> mapperInterface) {
        ClassLoaderKit loader = this.sqlManager.getClassLoaderKit();
        if (BeanKit.queryLambdasSupport) {
            return (T)Proxy.newProxyInstance(loader.getPreferredLoader(), new Class[]{mapperInterface}, (InvocationHandler)new MapperJava8Proxy(this.mapperConfig, this.sqlManager, mapperInterface));
        }
        return (T)Proxy.newProxyInstance(loader.getPreferredLoader(), new Class[]{mapperInterface}, (InvocationHandler)new MapperJavaProxy(this.mapperConfig, this.sqlManager, mapperInterface));
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    public void setSqlManager(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public MapperConfigBuilder getMapperConfig() {
        return this.mapperConfig;
    }

    public void setMapperConfig(MapperConfigBuilder mapperConfig) {
        this.mapperConfig = mapperConfig;
    }
}

